#include "io.h"


struct cylinder {
	int outword;
	int outbit;
	int inword;
	int inbit;
};



struct cylinder vcylinder_list[] = {
	{ 1, 8, 1, 9 },	// 1a 1b
	{ 1, 10, 1, 11 }, // 2a 2b 
	{ 1, 12, 1, 13 }, // 3a 3b
	{ 1, 14, 1, 15 }, // 4a 4b
	{ 2, 0, 2, 1 },   // 5a 5b
	{ 2, 2, 2, 3 },   // 6a 6b
	{ 2, 4, 2, 5 },   // 7a 7b
	{ 2, 6, 2, 7 },   // 8a 8b
	{ 2, 8, 2, 9 },   // 9a 9b
	{ 2, 10, 2, 11 }, // 10a 10b
	{ 2, 12, 2, 13 }, // 11a 11b
	{ 2, 14, 2, 15 }, // 12a 12b
	{ 0, 0, 0, 1 },   // 13a 13b
	{ 0, 2, 0, 3 },   // 14a 14b
	{ 0, 4, 0, 5 },   // 15a 15b
	{ 0, 6, 0, 7 },   // 16a 16b
	{ 0, 8, 0, 9 },   // 17a 17b
	{ 0, 10, 0, 11 }, // 18a 18a
	{ 0, 12, 0, 13 }, // 19a 19b
	{ 0, 14, 0, 15 }, // 20a 20b
	{ 1, 0, 1, 1}     // 21a 21b
};


void set_vcyl(int cylnum, int state) {   // +1 for out, 0 for stop, -1 for retract
	int wordnum, bitnum;
	
	struct cylinder c = vcylinder_list[cylnum];
	
	if (state == 1) {     // out
		clr_o(c.inword, c.inbit);
		set_o(c.outword, c.outbit);
		return;
	}
	if (state == -1) {            // in
	  clr_o(c.outword, c.outbit);
		set_o(c.inword, c.inbit);
		return;
	}
	if (state == 0) {
		clr_o(c.inword, c.inbit);
		clr_o(c.outword, c.outbit);
		return;
	}
}


void pump_on() {
  set_o(1, 6);
}

void pump_off() {
  clr_o(1, 6);
}

void power_on() {
  set_o(1, 7);
}

void power_off() {
  clr_o(1, 7);
}

void air_on() {
  set_o(1, 4);
}

void air_off() {
  clr_o(1, 4);
}

void spare_on() {
  set_o(1, 5);
}

void spare_off() {
  clr_o(1, 5);
}

// +1 is right, 0 is stop, -1 is left
void horiz(int dir) {
  switch (dir) {
  case 1:
    clr_o(1, 3);
    set_o(1, 2);
    break;
  case 0:
    clr_o(1, 2);
    clr_o(1, 3);
    break;
  case -1:
    clr_o(1, 2);
    set_o(1, 3);
    break;
  }
}
