/***************************************************************************
 *
 *  all_outputs.c
 *
 *  This program is used to test the PCI-DDA02/16 outputs on on ports.
 *  A mix of Warren Jaspers test_dda0X-1.6.c and Curt Wuollet's smio.c
 *  Linux loadable module(pci-dda0X_16).
 *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "pci-dda0X-16.h"	/* Changed from dio.h */

char DevNameIO[20];

int fds[6];
unsigned char values[6];

void setup_io(void);
void close_io(void);
void set_o(short reg,short bit);
void clr_o(short reg,short bit);



void setup_io(void) {
  /* open the dio */
  strcpy(DevNameIO, "/dev/dda0x-16/dio0_0A");
  if ((fds[3] = open(DevNameIO, O_RDWR )) < 0) {
    perror("DevNameIO");
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }
  strcpy(DevNameIO, "/dev/dda0x-16/dio0_0B");
  if ((fds[4] = open(DevNameIO, O_RDWR )) < 0) {
    perror(DevNameIO);
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }
  strcpy(DevNameIO, "/dev/dda0x-16/dio0_0C");
  if ((fds[5] = open(DevNameIO, O_RDWR )) < 0) {
    perror(DevNameIO);
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }

  strcpy(DevNameIO, "/dev/dda0x-16/dio0_1A");
  if ((fds[0] = open(DevNameIO, O_RDWR )) < 0) {
    perror("DevNameIO");
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }

  strcpy(DevNameIO, "/dev/dda0x-16/dio0_1B");
  if ((fds[1] = open(DevNameIO, O_RDWR )) < 0) {
    perror(DevNameIO);
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }

  strcpy(DevNameIO, "/dev/dda0x-16/dio0_1C");
  if ((fds[2] = open(DevNameIO, O_RDWR )) < 0) {
    perror(DevNameIO);
    printf("error opening device %s\n", DevNameIO);
    exit(2);
  }

  ioctl(fds[0], DIO_SET_DIRECTION, 0);
  ioctl(fds[1], DIO_SET_DIRECTION, 0);
  ioctl(fds[2], DIO_SET_DIRECTION, 0);
  ioctl(fds[3], DIO_SET_DIRECTION, 0);
  ioctl(fds[4], DIO_SET_DIRECTION, 0);
  ioctl(fds[5], DIO_SET_DIRECTION, 0);
}


void close_io(void) {
  close(fds[0]);
  close(fds[1]);
  close(fds[2]);
  close(fds[3]);
  close(fds[4]);
  close(fds[5]);
}


void set_o(short reg,short bit) {
  unsigned char value;

  value = values[reg];
  value = value | (1 << bit);
  write(fds[reg], &value, 1);
}


void clr_o(short reg,short bit) {
  unsigned char value;

  value = values[reg];
  value = value & ~(1 << bit);
  write(fds[reg], &value, 1);
}
