struct cylinder {
	int outword;
	int outbit;
	int inword;
	int inbit;
};



struct cylinder vcylinder_list[] = {
	{ 1, 8, 1, 9 },	// 1a 1b
	{ 1, 10, 1, 11 }, // 2a 2b 
	{ 1, 12, 1, 13 }, // 3a 3b
	{ 1, 14, 1, 15 }, // 4a 4b
	{ 2, 0, 2, 1 },   // 5a 5b
	{ 2, 2, 2, 3 },   // 6a 6b
	{ 2, 4, 2, 5 },   // 7a 7b
	{ 2, 6, 2, 7 },   // 8a 8b
	{ 2, 8, 2, 9 },   // 9a 9b
	{ 2, 10, 2, 11 }, // 10a 10b
	{ 2, 12, 2, 13 }, // 11a 11b
	{ 2, 14, 2, 15 }, // 12a 12b
	{ 0, 0, 0, 1 },   // 13a 13b
	{ 0, 2, 0, 3 },   // 14a 14b
	{ 0, 4, 0, 5 },   // 15a 15b
	{ 0, 6, 0, 7 },   // 16a 16b
	{ 0, 8, 0, 9 },   // 17a 17b
	{ 0, 10, 0, 11 }, // 18a 18a
	{ 0, 12, 0, 13 }, // 19a 19b
	{ 0, 14, 0, 15 }, // 20a 20b
	{ 1, 0, 1, 1}     // 21a 21b
}


void set_vcyl(int cylnum, int state) {   // +1 for out, 0 for stop, -1 for retract
	int wordnum, bitnum;
	
	struct cylinder c = vcylinder_list[cylnum];
	
	if (state == 1) {     // out
		clr_o(c.inword, c.inbit);
		set_o(c.outword, c.outbit);
		return;
	}
	if (state == -1) {            // in
	  clr_o(c.outword, c.outbit);
		set_o(c.inword, c.inbit);
		return;
	}
	if (state == 0) {
		clr_o(c.inword, c.inbit);
		clr_o(c.outword, c.outbit);
		return;
	}
}


void test_vertical() {
	int i;
	
	for (i=0; i<21; i++) {
		set_vcyl(i, 1);
	}    // everything is extending
	
	usleep(100000);
	
	for (i=0; i<21; i++) {
		set_vcyl(i, -1);
	}    // everything is retracting
	
	usleep(100000);
	
	for (i=0; i<21; i++) {
		set_vcyl(i, 0);
	}    // all stop
}
	
void wave(int speed) {
	for (i=0; i<21; i++) {
		set_vcyl(i, 0);
		set_vcyl(i+1, -1);
		set_vcyl(i+2, 1);
		usleep(speed);
	}
}
			
	
wave(100000);







struct event {
	int cyl_num;
	int dir;
	int time;
};


struct event wiggle_floor[] = {
	{ 1, 1, 0 },
	{ 2, 1, 0 },
	{ 3, 1, 0 },
	{ 4, 1, 100 },
	{ ...
	...
}

void run_event_list(struct event *eventlist) {
  	struct event *current_event = eventlist[0];
  
  	while (!end_event(e)) {
  		do_event(e);
  		if (e->time > 0) usleep(e->time * 1000);
  	}
}


void do_event(struct event *e) {
	int cyl_num = e->cyl_num;
	int dir = e->dir;
	int wordnum, bitnum;
	
	struct cylinder *c = cylinder_list[cyl_num];
	
	if (dir == 1) {     // out
		wordnum = c->outword;
		bitnum = c->outbit;
	} else {            // in
	   wordnum = c->inword;
	   bitnum = c->inbit;
	}
	
	
	
