#include <stdio.h>
#include <math.h>
#include <stdlib.h>


#define LEN 21

static double c2 = 0.1;  // square velocity
static double d = 0.1;   // damping coefficient
static double dt = 0.1;  // integration time

double x[LEN];          // source array
double xdot[LEN];
double y[LEN];          // destination array
double ydot[LEN];


void zero(double *x) {
  int i;
  for (i=0; i<LEN; i++) x[i] = 0.;
}


void sim_drop_pebble(double in) {
  x[10] = in;
}


void print(double *x) {
  int i;
  for (i=0; i<LEN; i++) {
    printf("%0.1f ", x[i]);
  }
  printf("\n");
  fflush(stdout);
}


void copy() {
  int i;
  for (i=0; i<LEN; i++) {
    x[i] = y[i];
    xdot[i] = ydot[i];
  }
}


double laplacian(double *x) {
  return (*(x+1) - *(x)) - (*(x) - *(x-1));
}


void sim_update() {
  int i;
  for (i=1; i<LEN-1; i++) {
    ydot[i] = xdot[i] + dt * (c2 * laplacian(&x[i]) - d * xdot[i]);
    y[i] = x[i] + dt * xdot[i];
  }
  copy();
#define SIM_DEBUG
#ifdef SIM_DEBUG
  print(x);
#endif
}


void sim_init() {
  char *env_c2 = getenv("SIM_C2");
  char *env_d = getenv("SIM_DAMPING");
  char *env_dt = getenv("SIM_DT");

  if (env_c2) c2 = atof(env_c2);
  if (env_d) d = atof(env_d);
  if (env_dt) dt = atof(env_dt);

  fprintf(stderr, "c2=%lf d=%lf dt=%lf\n", c2, d, dt);

  zero(x);
  zero(xdot);
  zero(y);
  zero(ydot);
}
