#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "simulator.h"

int pipe_fd;


void drop_pebble(double *x) {
  x[10] = 1.0;
}


int check_for_input() {
  char msg[80];
  int n;

  n = read(pipe_fd, msg, 80);
  if (n > 0) {
    // your message is in buf; interpret it wisely
    // ...
    printf("got %s\n", msg);
    fflush(stdout);
    return 1;
  }
  return 0;
}
  
  
main(int argc, char *argv[]) {
  pipe_fd = open(getenv("PIPE_NAME"), O_RDONLY);
  if (fcntl(pipe_fd, F_SETFL, O_NONBLOCK)) perror("fcntl");

  sim_init();

  while (1) {
    if (check_for_input()) sim_drop_pebble(1.0);

    sim_update();
    usleep(50000);
  }
}
