//ExtAliveMsgCallback.java:  Defines a callback method for capturing
//                           "alive" messages from QDDS hubs.
//
//   8/9/2002 -- [ET]
//

package qdds;

/**
 * Interface ExtAliveMsgCallback defines a callback method for capturing
 * "alive" messages from QDDS hubs.
 */
public interface ExtAliveMsgCallback
{
    /**
     * Callback method for capturing "alive" messages from QDDS hubs.
     * @param msgNum message number.
     * @param hostNameStr name of host that message came from.
     * @param versionStr version string reported by host.
     */
  public void reportAliveMsg(long msgNum, String hostNameStr,
                                                         String versionStr);
}
