//ExtWriteFileCallback.java:  Defines a callback method for capturing data
//                            that would have been written to files.
//
//  7/26/2002 -- [ET]
//   8/9/2002 -- [ET]  Modified to include host name in callback.
//  8/26/2002 -- [ET]  Modified to include host message-ID # in callback.
//

package qdds;

/**
 * Interface ExtWriteFileCallback defines a callback method for capturing
 * data that would have been written to files.
 */
public interface ExtWriteFileCallback
{
    /**
     * Callback method for capturing data that would have been written
     * to files.
     * @param msgNum message number.
     * @param msgStr message data string.
     * @param hostNameStr name of QDDS hub that message came from.
     * @param hostMessageID message ID number from QDDS hub.
     */
  public void writeFile(long msgNum, String msgStr, String hostNameStr,
                                                        long hostMessageID);
}
