/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import qdm.Histories;
import qdm.LogMessage;
import qdmutil.LogIt;
import qdmutil.Util;

public class Config
extends qdmutil.Config {
    public static String polldir = "polldir/";
    public static String oldinput = "oldinput/";
    public static Vector outputdirs;
    public static String catalog;
    public static String logdir;
    public static String eqcomments;
    public static String eqaddons;
    public static String tempdir;
    public static int poll_wait_time;
    public static float maintenance_hour;
    public static int retain_catalog;
    public static int retain_outputspool;
    public static int retain_oldinput;
    public static int retain_logdir;
    public static int retain_events;
    public static int global_log;
    public static final int MAX_LOG_LINE_LENGTH = 70;
    public static String initial_date;
    public static String eol;
    private static String configFileName;
    private static long config_last_modified;
    private static boolean exit_now;
    private static LogIt log_it;
    private static DateFormat date_f;
    public static final int ERROR_SPOOLDIR = -1;
    public static Config config;
    public static Histories histories;

    private String deblank(String s) {
        int i;
        int n = s.length();
        for (i = n - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        return s.substring(0, i + 1);
    }

    private String getArg(String line, String prompt) {
        String ret = null;
        if (line.startsWith(prompt)) {
            int len;
            int i;
            for (i = len = prompt.length(); i < line.length() && line.charAt(i) == ' '; ++i) {
            }
            ret = line.substring(i);
            ret = Util.deblank(ret);
        }
        return ret;
    }

    public int toInteger(String s) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            System.out.println("Number problem: " + e);
        }
        return i;
    }

    public float toFloat(String s) {
        float f = 0.0f;
        try {
            Float F = Float.valueOf(s);
            f = F.floatValue();
        }
        catch (NumberFormatException e) {
            System.out.println("Number problem: " + e);
        }
        return f;
    }

    public Config() {
    }

    public Config(String configFile) {
        if (configFile != null) {
            configFileName = configFile;
        }
    }

    public boolean load(boolean init) {
        outputdirs = new Vector(1, 1);
        try {
            String s;
            FileReader fr = new FileReader(configFileName);
            BufferedReader br = new BufferedReader(fr);
            while (br.ready() && (s = br.readLine()) != null) {
                String arg = this.getArg(s, "POLL WAIT TIME:");
                if (null != arg) {
                    poll_wait_time = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "POLL DIRECTORY:");
                if (null != arg) {
                    polldir = arg;
                    continue;
                }
                arg = this.getArg(s, "OUTPUTSPOOL DIRECTORY:");
                if (null != arg) {
                    outputdirs.add(new String(arg));
                    continue;
                }
                arg = this.getArg(s, "OLDINPUT DIRECTORY:");
                if (null != arg) {
                    oldinput = arg;
                    continue;
                }
                arg = this.getArg(s, "CATALOG DIRECTORY:");
                if (null != arg) {
                    catalog = arg;
                    continue;
                }
                arg = this.getArg(s, "LOG DIRECTORY:");
                if (null != arg) {
                    logdir = arg;
                    continue;
                }
                arg = this.getArg(s, "TEMPORARY DIRECTORY:");
                if (null != arg) {
                    tempdir = arg;
                    continue;
                }
                arg = this.getArg(s, "MAINTENANCE HOUR:");
                if (null != arg) {
                    maintenance_hour = this.toFloat(arg);
                    continue;
                }
                arg = this.getArg(s, "DAYS TO RETAIN OUTPUTSPOOL FILES:");
                if (null != arg) {
                    retain_outputspool = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "DAYS TO RETAIN OLDINPUT FILES:");
                if (null != arg) {
                    retain_oldinput = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "DAYS TO RETAIN LOG FILES:");
                if (null != arg) {
                    retain_logdir = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "DAYS TO RETAIN EVENTS:");
                if (null != arg) {
                    retain_events = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "INITIAL DATE:");
                if (null != arg) {
                    initial_date = arg;
                    continue;
                }
                arg = this.getArg(s, "LOG LEVEL:");
                if (null != arg) {
                    global_log = this.toInteger(arg);
                    continue;
                }
                arg = this.getArg(s, "COMMENTS DIRECTORY:");
                if (null != arg) {
                    eqcomments = arg;
                    continue;
                }
                arg = this.getArg(s, "ADDONS DIRECTORY:");
                if (null == arg) continue;
                eqaddons = arg;
            }
        }
        catch (IOException e) {
            System.out.println("\nProblem reading configuration file.");
            System.out.println("Using defaults\n");
        }
        polldir = Config.makeDirectory(polldir);
        logdir = Config.makeDirectory(logdir);
        log_it = new LogMessage(true);
        if (outputdirs.size() == 0) {
            outputdirs.add(new String("outputspool/"));
        }
        for (int i = 0; i < outputdirs.size(); ++i) {
            String temp = (String)outputdirs.elementAt(i);
            String temp2 = Config.makeDirectory(temp);
            if (temp2.equals(temp)) continue;
            outputdirs.remove(i);
            outputdirs.insertElementAt(temp2, i);
        }
        catalog = Config.makeDirectory(catalog);
        tempdir = Config.makeDirectory(tempdir);
        oldinput = Config.makeDirectory(oldinput);
        eqcomments = Config.makeDirectory(eqcomments);
        eqaddons = Config.makeDirectory(eqaddons);
        File file = new File(configFileName);
        if (file.exists()) {
            config_last_modified = file.lastModified();
        } else {
            System.out.println("\nConfig file doesn't exist.");
            Config.writeConfigFile();
        }
        log_it.write(1, true, "QDM Merge 1.2.4 Level 2007/10/01");
        log_it.write(1, true, "POLL WAIT TIME:         " + poll_wait_time);
        log_it.write(1, true, "POLL DIRECTORY:         " + polldir);
        Iterator it = outputdirs.iterator();
        while (it.hasNext()) {
            log_it.write(1, true, "OUTPUT SPOOL DIRECTORY: " + (String)it.next());
        }
        log_it.write(1, true, "CATALOG DIRECTORY:      " + catalog);
        log_it.write(1, true, "OLDINPUT DIRECTORY:     " + oldinput);
        log_it.write(1, true, "LOG DIRECTORY:          " + logdir);
        log_it.write(1, true, "TEMPORARY DIRECTORY:    " + tempdir);
        log_it.write(1, true, "MAINTENANCE HOUR:       " + maintenance_hour);
        log_it.write(1, true, "DAYS TO RETAIN OUTPUT SPOOL FILES: " + retain_outputspool);
        log_it.write(1, true, "DAYS TO RETAIN OLD INPUT FILES: " + retain_oldinput);
        log_it.write(1, true, "DAYS TO RETAIN EVENTS:  " + retain_events);
        log_it.write(1, true, "DAYS TO LOG FILES:      " + retain_logdir);
        log_it.write(1, true, "INITIAL DATE:           " + initial_date);
        log_it.write(1, true, "LOG LEVEL:              " + global_log);
        log_it.write(1, true, "");
        if (!qdmutil.Config.init(log_it)) {
            log_it.write(1, true, "regions.xml file is missing!");
            System.exit(1);
        }
        return true;
    }

    public static void writeConfigFile() {
        try {
            System.out.println("Writing config to " + configFileName + "\n");
            FileWriter fw = new FileWriter(configFileName);
            fw.write("POLL WAIT TIME: " + poll_wait_time + eol);
            fw.write("POLL DIRECTORY: " + polldir + eol);
            for (int i = 0; i < outputdirs.size(); ++i) {
                String outputdir = (String)outputdirs.elementAt(i);
                fw.write("OUTPUTSPOOL DIRECTORY: " + outputdir + eol);
            }
            fw.write("OLDINPUT DIRECTORY: " + oldinput + eol);
            fw.write("CATALOG DIRECTORY: " + catalog + eol);
            fw.write("LOG DIRECTORY: " + logdir + eol);
            fw.write("TEMPORARY DIRECTORY: " + tempdir + eol);
            fw.write("MAINTENANCE HOUR: " + maintenance_hour + eol);
            fw.write("DAYS TO RETAIN OUTPUTSPOOL FILES: " + retain_outputspool + eol);
            fw.write("DAYS TO RETAIN OLDINPUT FILES: " + retain_oldinput + eol);
            fw.write("DAYS TO RETAIN LOG FILES: " + retain_logdir + eol);
            fw.write("DAYS TO RETAIN EVENTS: " + retain_events + eol);
            fw.write("INITIAL DATE: " + initial_date + eol);
            fw.write("LOG LEVEL: " + global_log + eol);
            fw.write("COMMENTS DIRECTORY: " + eqcomments + eol);
            fw.write("ADDONS DIRECTORY: " + eqaddons + eol);
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IOException " + e + " writing " + configFileName);
        }
    }

    public static void mySleep(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String pollDirectory() {
        return polldir;
    }

    public static Vector outputSpoolDirs() {
        return outputdirs;
    }

    public static String catalogDirectory() {
        return catalog;
    }

    public static String oldInputDirectory() {
        return oldinput;
    }

    public static String logDirectory() {
        return logdir;
    }

    public static String tempDirectory() {
        return tempdir;
    }

    public static boolean exit() {
        return exit_now;
    }

    public static void kill() {
        exit_now = true;
    }

    public static void activityLog(String message) {
        log_it.write(1, true, message);
    }

    public static String now() {
        if (date_f == null) {
            date_f = DateFormat.getDateTimeInstance(1, 3);
        }
        Date date = new Date();
        return new String(date_f.format(date));
    }

    public static boolean configChanged() {
        boolean ret = false;
        File file = new File(configFileName);
        if (file.exists() && config_last_modified != file.lastModified()) {
            ret = true;
        }
        return ret;
    }

    public static String makeDirectory(String name) {
        File file;
        if (name.length() == 0) {
            return name;
        }
        char c = name.charAt(name.length() - 1);
        if (c != '/') {
            name = name + "/";
        }
        if ((file = new File(name)).isDirectory()) {
            return name;
        }
        try {
            System.out.println("Directory " + name + " does not exist.  Create it.");
            file.mkdir();
        }
        catch (SecurityException e) {
            Config.error("Security error " + e);
        }
        return name;
    }

    static {
        catalog = "catalog/";
        logdir = "logdir/";
        eqcomments = "eqcomments/";
        eqaddons = "eqaddons/";
        tempdir = "tempdir/";
        poll_wait_time = 15;
        maintenance_hour = 13.5f;
        retain_catalog = 14;
        retain_outputspool = 14;
        retain_oldinput = 14;
        retain_logdir = 5;
        retain_events = 8;
        global_log = 0;
        initial_date = "200101010000";
        eol = System.getProperty("line.separator");
        configFileName = "QDM.config";
        exit_now = false;
        date_f = null;
    }
}

