/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import qdm.Config;
import qdmutil.LogIt;

public class LogMessage
implements LogIt {
    FileWriter fw = null;
    boolean enabled = false;
    SimpleDateFormat sdf = null;
    String filename;
    File file;

    public LogMessage() {
        try {
            this.sdf = new SimpleDateFormat("kk:mm:ss");
            this.filename = this.newFileName();
            System.out.println("Creating new log file: " + this.filename);
            this.file = new File(Config.logDirectory(), this.filename);
            this.fw = new FileWriter(this.file);
        }
        catch (IOException e) {
            System.out.println("Problem in LogMessage Constructor: " + e);
        }
    }

    public LogMessage(boolean enabled) {
        this();
        this.enabled = enabled;
    }

    String newFileName() {
        Calendar cal = Calendar.getInstance();
        long d = 1 + cal.get(2) + 100 * cal.get(1);
        d = (long)cal.get(5) + 100L * d;
        d = (long)cal.get(11) + 100L * d;
        d = (long)cal.get(12) + 100L * d;
        return "" + d;
    }

    void enable() {
        this.enabled = true;
    }

    void disable() {
        this.enabled = false;
    }

    public void write(int level, boolean console, String s) {
        String currtime = this.sdf.format(new Date()) + ": ";
        if (console) {
            System.out.println(currtime + s);
        }
        if (!this.enabled) {
            return;
        }
        if (Config.global_log >= level) {
            try {
                String stemp;
                String tmpfilename = this.newFileName();
                if (!tmpfilename.regionMatches(6, this.filename, 6, 2)) {
                    this.fw.close();
                    this.filename = tmpfilename;
                    this.file = new File(Config.logDirectory(), this.filename);
                    this.fw = new FileWriter(this.file);
                    this.fw.write(currtime + "Version: " + "1.2.4 Level 2007/10/01" + Config.eol);
                }
                if (s.length() >= 70) {
                    try {
                        stemp = s.substring(0, 70);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        stemp = "StringIndexOutofBounds";
                    }
                } else {
                    stemp = s;
                }
                this.fw.write(currtime + stemp + Config.eol);
                this.fw.flush();
            }
            catch (IOException e) {
                System.out.println("Problem writing " + s);
            }
        }
    }

    void close() {
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

