/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.util.Iterator;
import qdmutil.Config;
import qdmutil.EQEvent;
import qdmutil.Point;

public class EQEventsUtils {
    public static final int TDIFF = 16000;
    public static final float DDIFF = 100.0f;
    public static final int RTDIFF = 10;
    public static final double KMDEG = 111.2;
    public static final double maxlatdiff = 0.8992805755395683;
    protected static final double mincos = Math.cos(Math.toRadians(0.8992805755395683));
    protected static final int DUPLICATE_TRUE = 0;
    protected static final int DUPLICATE_FALSE_SAME_SOURCE = 1;
    protected static final int DUPLICATE_FALSE_TIME_DIFF_LOW = 2;
    protected static final int DUPLICATE_FALSE_TIME_DIFF_HIGH = 3;
    protected static final int DUPLICATE_FALSE_LAT_DIFF = 4;
    protected static final int DUPLICATE_FALSE_DIST_DIFF = 5;

    protected EQEventsUtils() {
    }

    public static boolean determineAuthor(EQEvent eq) {
        return Config.getRegions() != null && Config.getRegions().isAuthor(eq);
    }

    public static double[] calculateDirCos(EQEvent eq) {
        double[] dircos = new double[3];
        double lat = eq.getLatitude();
        double lon = eq.getLongitude();
        double latr = 0.01745329 * lat;
        double lonr = 0.01745329 * lon;
        double aaa = 0.996647 * Math.tan(latr);
        latr = Math.atan(aaa);
        double clatr = 1.570796327 - latr;
        if (lonr < 0.0) {
            lonr += 6.283185307;
        }
        double sclat = Math.sin(clatr);
        double cclat = Math.cos(clatr);
        double slon = Math.sin(lonr);
        double clon = Math.cos(lonr);
        dircos[0] = sclat * clon;
        dircos[1] = sclat * slon;
        dircos[2] = cclat;
        return dircos;
    }

    public static Point createPoint(EQEvent eq) {
        return EQEventsUtils.createPoint(eq.getLongitude(), eq.getLatitude());
    }

    public static Point createPoint(double lon, double lat) {
        return new Point(lon, lat);
    }

    public static boolean tooCloseInTime(EQEvent eq1, EQEvent eq2) {
        return EQEventsUtils.checkTimeDiff(eq1, eq2) < 0;
    }

    private static int checkTimeDiff(EQEvent eq1, EQEvent eq2) {
        long time2;
        long time1 = eq1.getTime().getTime();
        long timeDiff = time1 - (time2 = eq2.getTime().getTime());
        if (timeDiff > 16000L) {
            return 3;
        }
        if (timeDiff < -16000L) {
            return 2;
        }
        return -1;
    }

    protected static int checkDuplicate(EQEvent eq1, EQEvent eq2) {
        double[] dircos2;
        if (eq1.getNetID().equals(eq2.getNetID())) {
            return 1;
        }
        int timeCheck = EQEventsUtils.checkTimeDiff(eq1, eq2);
        if (timeCheck >= 0) {
            return timeCheck;
        }
        if (Math.abs(eq1.getLatitude() - eq2.getLatitude()) > 0.8992805755395683) {
            return 4;
        }
        double[] dircos1 = eq1.getDirCos();
        double x = dircos1[0] * (dircos2 = eq2.getDirCos())[0] + dircos1[1] * dircos2[1] + dircos1[2] * dircos2[2];
        if (x < mincos) {
            return 5;
        }
        return 0;
    }

    public static boolean duplicate(EQEvent eq1, EQEvent eq2) {
        return EQEventsUtils.checkDuplicate(eq1, eq2) == 0;
    }

    protected static String toString(boolean b) {
        return b ? "Y" : "N";
    }

    public static String toString(EQEvent eq) {
        return "author=" + EQEventsUtils.toString(eq.isAuthor()) + ", source=" + eq.getNetID() + ", lat=" + eq.getLatitude() + ", long=" + eq.getLongitude() + ", mag=" + eq.getMagnitude() + ", time=" + eq.getTime() + ", trump=" + EQEventsUtils.toString(eq.getTrump());
    }

    public static EQEvent getDuplicate(Iterator it, EQEvent eq, boolean isSorted) {
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof EQEvent)) continue;
            EQEvent oldEq = (EQEvent)obj;
            int dupVal = EQEventsUtils.checkDuplicate(oldEq, eq);
            switch (dupVal) {
                case 0: {
                    return oldEq;
                }
                case 3: {
                    if (!isSorted) break;
                    return null;
                }
            }
        }
        return null;
    }

    public static int lowpriority(EQEvent eq0, EQEvent eq1) {
        if (eq0.getTrump()) {
            return 1;
        }
        if (eq1.getTrump()) {
            return 0;
        }
        if (eq0.isAuthor() && !eq1.isAuthor()) {
            return 1;
        }
        if (!eq0.isAuthor() && eq1.isAuthor()) {
            return 0;
        }
        if (!eq0.isAuthor() && !eq1.isAuthor()) {
            String net0 = eq0.getNetID();
            String net1 = eq1.getNetID();
            if (net0.equals("us") && !net1.equals("us")) {
                return 1;
            }
            if (!net0.equals("us") && net1.equals("us")) {
                return 0;
            }
        }
        if (eq0.getMagnitude() >= eq1.getMagnitude()) {
            return 1;
        }
        return 0;
    }
}

