/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import qdmutil.Config;
import qdmutil.LogIt;

public class ParseXML {
    private File file;
    private Document doc;

    public ParseXML(File file) {
        this.file = file;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getFilename() {
        Element child;
        String name = null;
        LogIt logIt = Config.getLogIt();
        try {
            this.doc = ParseXML.parse(this.file);
        }
        catch (SAXParseException e) {
            String s = e.toString();
            if (s.length() > 50) {
                logIt.write(1, true, "Parse error: " + s.substring(0, 50));
                logIt.write(1, true, s.substring(50));
            } else {
                logIt.write(1, true, "Parse error: " + s);
            }
            return "";
        }
        catch (Exception x) {
            x.printStackTrace();
            return "";
        }
        NodeList children = this.doc.getElementsByTagName("file");
        if (children.getLength() == 0) {
            logIt.write(1, true, "Error. No file element found in file.");
            return null;
        }
        if (children.getLength() > 1) {
            logIt.write(3, true, "Warning. More than one file element");
        }
        if (children.item(0) instanceof Element && (name = (child = (Element)children.item(0)).getAttribute("name")) != null && name.length() == 0) {
            logIt.write(1, true, "Error. No file \"name\" element found");
            name = null;
        }
        return name;
    }

    public static Document parse(InputSource is) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        parser.parse(is);
        Document doc = parser.getDocument();
        return doc;
    }

    public static Document parse(File file) throws SAXException, IOException {
        return ParseXML.parse(new InputSource(new FileInputStream(file)));
    }

    public static Document parse(URL url) throws SAXException, IOException {
        return ParseXML.parse(new InputSource(url.openStream()));
    }
}

