/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import qdmutil.Config;
import qdmutil.EQEventsUtils;
import qdmutil.LogIt;
import qdmutil.Point;

public class Region
extends ArrayList {
    public String netid;
    public String regionid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region(String netid, String regionid, String dir, String Filename) throws IOException {
        this.netid = netid;
        this.regionid = regionid;
        InputStreamReader fr = null;
        if (Filename.equalsIgnoreCase("DEFAULT")) {
            return;
        }
        try {
            String line;
            fr = new FileReader(dir + Filename);
            BufferedReader br = new BufferedReader(fr);
            while (null != (line = br.readLine())) {
                if (line.length() < 5) {
                    break;
                }
                StringTokenizer tok = new StringTokenizer(line);
                String s = tok.nextToken();
                double lat = Double.parseDouble(s);
                s = tok.nextToken();
                double lon = Double.parseDouble(s);
                super.add(EQEventsUtils.createPoint(lon, lat));
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Region(String netid, String regionid, Element region) {
        this.netid = netid;
        this.regionid = regionid;
        LogIt logIt = Config.getLogIt();
        NodeList coordinates = region.getElementsByTagName("coordinate");
        int nCoord = coordinates.getLength();
        for (int i = 0; i < nCoord; ++i) {
            Element coord = (Element)coordinates.item(i);
            double lat = Double.parseDouble(coord.getAttribute("latitude"));
            double lon = Double.parseDouble(coord.getAttribute("longitude"));
            super.add(EQEventsUtils.createPoint(lon, lat));
            logIt.write(1, false, "    coordinates: " + lat + " : " + lon);
        }
    }

    public boolean inpoly(Point xy) {
        boolean bool = false;
        boolean inside = false;
        int nvert = super.size();
        if (nvert == 0) {
            return true;
        }
        Point[] p = super.toArray(new Point[0]);
        double x = xy.x;
        double y = xy.y;
        for (int i = 0; i < nvert; ++i) {
            int in = i + 1;
            if (in >= nvert) {
                in = 0;
            }
            if (p[in].y == p[i].y && p[in].x == p[i].x) continue;
            double sine = (x - p[i].x) * (p[in].y - p[i].y) - (y - p[i].y) * (p[in].x - p[i].x);
            if (sine == 0.0) {
                if (((x - p[i].x) * (p[in].x - p[i].x) + (y - p[i].y) * (p[in].y - p[i].y)) * ((x - p[in].x) * (p[in].x - p[i].x) + (y - p[in].y) * (p[in].y - p[i].y)) > 0.0) continue;
                return true;
            }
            if (!(y > p[in].y && y <= p[i].y && sine < 0.0) && (!(y <= p[in].y) || !(y > p[i].y) || !(sine > 0.0))) continue;
            bool = !bool;
        }
        if (bool) {
            inside = true;
        }
        return inside;
    }
}

