/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import qdm.Config;
import qdmutil.EQEventsUtils;
import qdmutil.LogIt;
import qdmutil.Regions;
import qdmutil.Util;

public class EQ {
    protected String data;
    protected String timestamp;
    protected boolean trump;

    public EQ() {
        this.data = "";
        this.timestamp = "";
        this.trump = false;
    }

    public EQ(String s) {
        this.data = s;
        this.timestamp = "";
        this.trump = false;
        this.replaceCtrlD();
    }

    public EQ(String s, String ts) {
        this.data = s;
        this.timestamp = ts;
        this.replaceCtrlD();
    }

    public EQ(EQ eq) {
        this.data = eq.getStringData();
        this.timestamp = eq.getTimeStamp();
        this.trump = eq.getTrump();
    }

    public void setData(String s) {
        this.data = new String(s);
    }

    public String getData() {
        return this.getStringData();
    }

    public String getStringData() {
        return new String(this.data);
    }

    public byte[] getByteData() {
        return new String(this.data).getBytes();
    }

    public int byteCount() {
        return this.data.length();
    }

    private void replaceCtrlD() {
        this.data = this.data.replace('\u0004', ' ');
    }

    public String toString() {
        return new String(this.data);
    }

    public String getTimeStamp() {
        return new String(this.timestamp);
    }

    public void setTimeStamp() {
        this.timestamp = Util.timeStamp();
    }

    public String getCode() {
        if (this.data.length() < 2) {
            return "  ";
        }
        return this.data.substring(0, 2);
    }

    public boolean equals(EQ eq) {
        return eq.equals(this.data);
    }

    public String getEventID() {
        if (this.data.length() <= 10) {
            return "        ";
        }
        String cleanId = this.data.substring(2, 10).trim();
        while (cleanId.length() < 8) {
            cleanId = " " + cleanId;
        }
        return this.data.substring(2, 10).toLowerCase();
    }

    public String getFullEventID() {
        return this.getNetID() + this.getEventID().trim();
    }

    public void putEventID(String eventID) {
        String e = new String(eventID);
        int i = e.length();
        while (e.endsWith(" ")) {
            e = " " + e;
            e = e.substring(0, i);
        }
        this.data = this.getCode() + e.toLowerCase() + this.data.substring(10);
    }

    public String getNetID() {
        if (this.data.length() < 12) {
            return "  ";
        }
        return this.data.substring(10, 12).toLowerCase();
    }

    public String getNetIDi() {
        if (this.data.length() < 12) {
            return "  ";
        }
        return this.data.substring(10, 12);
    }

    public String getVersion() {
        if (this.data.length() < 13 || this.data.charAt(12) < ' ') {
            return " ";
        }
        return this.data.substring(12, 13);
    }

    public String getDate() {
        if (this.data.length() < 28 || this.getCode().equals("DE") || this.getCode().equals("TR")) {
            return this.timestamp.substring(0, 4) + this.timestamp.substring(5, 7) + this.timestamp.substring(8, 10) + this.timestamp.substring(11, 13) + this.timestamp.substring(14, 16) + this.timestamp.substring(17, 19) + "0";
        }
        return this.data.substring(13, 28);
    }

    public boolean isValidDate() {
        String code = this.getCode();
        if (code.equals("DE") || code.equals("TR")) {
            return true;
        }
        if (this.data.length() < 19) {
            return false;
        }
        int month = Util.atoi(this.data.substring(17, 19));
        return month >= 1 && month <= 12;
    }

    public void fillZeros() {
        String date = this.data.substring(13, 28);
        if (0 <= date.indexOf(32)) {
            String newdate = date.replace(' ', '0');
            this.data = this.data.substring(0, 13) + newdate + this.data.substring(28);
        }
    }

    protected float atof(String f) {
        Float ff;
        try {
            ff = new Float(f);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
        return ff.floatValue();
    }

    public float getLat() {
        if (this.data.length() <= 35) {
            return 0.0f;
        }
        return this.atof(this.data.substring(28, 35)) / 10000.0f;
    }

    public float getLon() {
        if (this.data.length() < 43) {
            return 0.0f;
        }
        return this.atof(this.data.substring(35, 43)) / 10000.0f;
    }

    int ckSum(String s) {
        int sum = 0;
        byte[] bs = s.getBytes();
        int len = bs.length;
        for (int i = 0; i < len; ++i) {
            sum = (sum & 1) != 0 ? (sum >> 1) + 32768 : (sum >>= 1);
            byte c = bs[i];
            sum += c;
            sum &= 0xFFFF;
        }
        return sum;
    }

    public void newCkSum() {
        String newline = this.data.substring(0, 79);
        int a = 36 + this.ckSum(newline) % 91;
        newline = newline + new Character((char)a).toString();
        this.setData(newline);
    }

    public boolean checkCkSum() {
        char b;
        if (this.data.length() < 80) {
            return false;
        }
        String newline = this.data.substring(0, 79);
        int a = 36 + this.ckSum(newline) % 91;
        return a == (b = this.data.charAt(79));
    }

    public boolean isAuthor() {
        return Character.isUpperCase(this.data.charAt(10));
    }

    public boolean setAuthor() {
        String netid = this.getNetID();
        float lon = this.getLon();
        float lat = this.getLat();
        Regions regions = Config.getRegions();
        boolean netfound = regions.isValidnetID(netid);
        if (netfound) {
            netid = regions.isAuthor(netid, EQEventsUtils.createPoint(lon, lat)) ? netid.toUpperCase() : netid.toLowerCase();
            this.data = this.data.substring(0, 10) + netid + this.data.substring(12);
        }
        return netfound;
    }

    boolean eventinfo() {
        LogIt logIt = Config.getLogIt();
        if (this.getCode().equals("E ") && !this.checkCkSum()) {
            logIt.write(1, true, "Bad checksum on line:\n" + this.data);
            return false;
        }
        String eventid = this.getEventID();
        this.putEventID(eventid);
        String netid = this.getNetID();
        String code = this.getCode();
        if (code.equals("E ")) {
            this.setAuthor();
            this.fillZeros();
            this.newCkSum();
        }
        this.timestamp = Util.timeStamp();
        return true;
    }

    boolean tooOld() {
        return Config.initial_date.compareTo(this.getDate()) > 0;
    }

    public boolean getTrump() {
        return this.trump;
    }

    void setTrump() {
        this.trump = true;
    }
}

