/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Element;
import qdm.Config;
import qdm.EQ;
import qdmutil.EQEvent;
import qdmutil.EQEventsUtils;
import qdmutil.Point;
import qdmutil.Util;

public class EQx
extends EQ
implements EQEvent {
    private boolean author;
    public double[] dircos = new double[]{2.0, 2.0, 2.0};
    private String msgType;
    private String eventID;
    private String netCode;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private float second;
    private int secondPrecision;
    private float latitude;
    private float longitude;
    private float depth;
    private float magnitude;
    private int depthPrecision;
    private int numStations;
    private int numPhases;
    public boolean isNumStations;
    public boolean isNumPhases;
    private float distFirstStation;
    private float rmsError;
    private float horizontalError;
    private float verticalError;
    private int rmsPrecision = 2;
    public boolean isDistFirstStation;
    public boolean isRmsError;
    public boolean isHorizontalError;
    public boolean isVerticalError;
    private int horizontalPrecision;
    private int verticalPrecision;
    private int azimuthalGap;
    public boolean isAzimuthalGap;
    protected char magnitudeType;
    public boolean isMagnitudeType;
    private int numStationsForMagnitude;
    public boolean isNumStationsForMagnitude;
    private float standardErrorMagnitude;
    public boolean isStandardErrorMagnitude;
    private char locationMethod;
    public boolean isLocationMethod;
    private NumberFormat form;
    private Point point = null;

    public EQx(EQ eq) {
        this.data = eq.getData();
        this.timestamp = eq.getTimeStamp();
        this.author = Character.isUpperCase(this.data.charAt(10));
        this.setVariables();
        this.trump = eq.trump;
        this.form = NumberFormat.getInstance();
        this.form.setGroupingUsed(false);
    }

    public EQx(Element el) {
    }

    public void setVariables() {
        this.isNumPhases = true;
        this.isNumStations = true;
        this.isVerticalError = true;
        this.isHorizontalError = true;
        this.isRmsError = true;
        this.isDistFirstStation = true;
        this.isNumStationsForMagnitude = true;
        this.isMagnitudeType = true;
        this.isAzimuthalGap = true;
        this.isLocationMethod = true;
        this.isStandardErrorMagnitude = true;
        try {
            this.year = Util.atoi(this.data.substring(13, 17));
            this.month = Util.atoi(this.data.substring(17, 19));
            this.day = Util.atoi(this.data.substring(19, 21));
            this.hour = Util.atoi(this.data.substring(21, 23));
            this.minute = Util.atoi(this.data.substring(23, 25));
            this.second = this.atof(this.data.substring(25, 27) + '.' + this.data.substring(27, 28));
            this.secondPrecision = 1;
            this.latitude = this.atof(this.data.substring(28, 31) + '.' + this.data.substring(31, 35));
            this.longitude = this.atof(this.data.substring(35, 39) + '.' + this.data.substring(39, 43));
            this.depth = this.atof(this.data.substring(43, 46) + '.' + this.data.substring(46, 47));
            this.depthPrecision = 1;
            String temp = this.data.substring(47, 49);
            this.magnitude = this.atof(temp.substring(0, 1) + '.' + temp.substring(1, 2));
            temp = this.data.substring(49, 52);
            if (temp.equals("   ") || temp.equals("***")) {
                this.isNumStations = false;
            } else {
                this.numStations = Util.atoi(temp);
            }
            temp = this.data.substring(52, 55);
            if (temp.equals("   ") || temp.equals("***")) {
                this.isNumPhases = false;
            } else {
                this.numPhases = Util.atoi(temp);
            }
            temp = this.data.substring(55, 59);
            if (temp.equals("    ")) {
                this.isDistFirstStation = false;
            } else {
                this.distFirstStation = this.atof(temp.substring(0, 3) + '.' + temp.substring(3, 4));
            }
            this.rmsPrecision = 2;
            temp = this.data.substring(59, 63);
            if (temp.equals("    ")) {
                this.isRmsError = false;
            } else {
                this.rmsError = this.atof(temp.substring(0, 2) + '.' + temp.substring(2, 4));
            }
            this.horizontalPrecision = 1;
            temp = this.data.substring(63, 67);
            if (temp.equals("    ")) {
                this.isHorizontalError = false;
            } else {
                this.horizontalError = this.atof(temp.substring(0, 3) + '.' + temp.substring(3, 4));
            }
            this.verticalPrecision = 1;
            temp = this.data.substring(67, 71);
            if (temp.equals("    ")) {
                this.isVerticalError = false;
            } else {
                this.verticalError = this.atof(temp.substring(0, 3) + '.' + temp.substring(3, 4));
            }
            temp = this.data.substring(71, 73);
            if (temp.equals("   ")) {
                this.isAzimuthalGap = false;
            } else {
                this.azimuthalGap = Util.atoi(temp);
            }
            temp = this.data.substring(73, 74);
            if (temp.equals("   ")) {
                this.isMagnitudeType = false;
            } else {
                this.magnitudeType = temp.charAt(0);
            }
            temp = this.data.substring(74, 76);
            if (temp.equals("  ")) {
                this.isNumStationsForMagnitude = false;
            } else {
                this.numStationsForMagnitude = Util.atoi(temp);
            }
            temp = this.data.substring(76, 78);
            if (temp.equals("  ")) {
                this.isStandardErrorMagnitude = false;
            } else {
                this.standardErrorMagnitude = this.atof(temp.substring(0, 1) + '.' + temp.substring(1, 2));
            }
            temp = this.data.substring(78, 79);
            if (temp.equals(" ")) {
                this.isLocationMethod = false;
            } else {
                this.locationMethod = temp.charAt(0);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            Config.getLogIt().write(1, true, "Problem with input: " + this.data);
        }
    }

    private String fmt(float f, int pre) {
        this.form.setMaximumFractionDigits(pre);
        this.form.setMinimumFractionDigits(pre);
        this.form.setMaximumIntegerDigits(12);
        this.form.setMinimumIntegerDigits(1);
        return this.form.format(f);
    }

    private String fmt(float f, int pre, int lead) {
        this.form.setMaximumFractionDigits(pre);
        this.form.setMinimumFractionDigits(pre);
        this.form.setMaximumIntegerDigits(12);
        this.form.setMinimumIntegerDigits(lead);
        return this.form.format(f);
    }

    private String fmti(int i, int d) {
        this.form.setMaximumIntegerDigits(d);
        this.form.setMinimumIntegerDigits(d);
        return this.form.format(i);
    }

    public String getStrYear() {
        return this.fmti(this.year, 4);
    }

    public String getStrMonth() {
        return this.fmti(this.month, 2);
    }

    public String getStrDay() {
        return this.fmti(this.day, 2);
    }

    public String getStrHour() {
        return this.fmti(this.hour, 2);
    }

    public String getStrMinute() {
        return this.fmti(this.minute, 2);
    }

    public String getStrSecond() {
        return this.fmt(this.second, this.secondPrecision, 2);
    }

    public String getStrLatitude() {
        return this.fmt(this.latitude, 4);
    }

    public String getStrLongitude() {
        return this.fmt(this.longitude, 4);
    }

    public String getStrDepth() {
        return this.fmt(this.depth, this.depthPrecision);
    }

    public String getStrMagnitude() {
        return this.fmt(this.magnitude, 1);
    }

    public String getStrNumStations() {
        return "" + this.numStations;
    }

    public String getStrNumPhases() {
        return "" + this.numPhases;
    }

    public String getStrDistFirstStation() {
        return "" + this.distFirstStation;
    }

    public String getStrRmsError() {
        return this.fmt(this.rmsError, this.rmsPrecision);
    }

    public String getStrHorizontalError() {
        return this.fmt(this.horizontalError, this.horizontalPrecision);
    }

    public String getStrVerticalError() {
        return this.fmt(this.verticalError, this.verticalPrecision);
    }

    public String getStrAzimuthalGap() {
        return "" + this.azimuthalGap;
    }

    public String getStrMagnitudeType() {
        return "" + this.magnitudeType;
    }

    public String getStrMagnitudeTypeExt() {
        String ret = "";
        switch (this.magnitudeType) {
            case 'B': {
                ret = "Mb = body wave magnitude";
                break;
            }
            case 'C': {
                ret = "Mca = coda amplitude magnitude";
                break;
            }
            case 'D': {
                ret = "Mcd = coda duration magnitude";
                break;
            }
            case 'E': {
                ret = "Me = energy magnitude";
                break;
            }
            case 'G': {
                ret = "Mgn = MAGNUM (pseudo-empirical local magnitude)";
                break;
            }
            case 'L': {
                ret = "Ml = local magnitude (synthetic Wood-Anderson)";
                break;
            }
            case 'O': {
                ret = "Mo = moment magnitude";
                break;
            }
            case 'P': {
                ret = "Mp = P-wave magnitude (Doug Neuhauser, UCB)";
                break;
            }
            case 'S': {
                ret = "Ms = surface wave magnitude";
            }
        }
        return ret;
    }

    public String getStrNumStationsForMagnitude() {
        return "" + this.numStationsForMagnitude;
    }

    public String getStrStandardErrorMagnitude() {
        return "" + this.standardErrorMagnitude;
    }

    public String getStrLocationMethod() {
        return "" + this.locationMethod;
    }

    public String getStrLocationMethodExt() {
        String ret = "";
        char lm = Character.toUpperCase(this.locationMethod);
        switch (lm) {
            case 'R': {
                ret = "RTP";
                break;
            }
            case 'I': {
                ret = "Isaiah";
                break;
            }
            case 'A': {
                ret = "Auryn";
                break;
            }
            case 'B': {
                ret = "Binder";
                break;
            }
            case 'H': {
                ret = "Hypoinverse";
                break;
            }
            case 'S': {
                ret = "st_relp (Doug Neuhauser, UCB)";
                break;
            }
            case 'L': {
                ret = "Local";
                break;
            }
            case 'Q': {
                ret = "Quarry";
            }
        }
        if (Character.isLowerCase(this.locationMethod)) {
            ret = ret + " (Confirmed by human review)";
        }
        return ret;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isAuthor() {
        return this.author;
    }

    public Calendar getDateTime() {
        String d = super.getDate();
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gc.set(this.year, this.month - 1, this.day, this.hour, this.minute, (int)this.second);
        return gc;
    }

    public int getIntMagnitude() {
        return Util.atoi(this.data.substring(47, 49));
    }

    public double[] getDirCos() {
        if (this.dircos[0] == 2.0) {
            this.dircos = EQEventsUtils.calculateDirCos(this);
        }
        return this.dircos;
    }

    private void createEqParam(DocumentImpl doc, Element e, String attr_name, String value) {
        Element param = doc.createElement("param");
        param.setAttribute("name", attr_name);
        param.setAttribute("value", value);
        e.appendChild(param);
    }

    public Element buildElement(DocumentImpl doc) {
        Element event = doc.createElement("event");
        this.setParam(event, doc);
        return event;
    }

    public void setParam(Element event, DocumentImpl doc) {
        event.setAttribute("network-code", this.getNetIDi());
        event.setAttribute("id", this.getEventID());
        event.setAttribute("version", this.getVersion());
        event.setAttribute("time-stamp", this.getTimeStamp());
        this.createEqParam(doc, event, "year", this.getStrYear());
        this.createEqParam(doc, event, "month", this.getStrMonth());
        this.createEqParam(doc, event, "day", this.getStrDay());
        this.createEqParam(doc, event, "hour", this.getStrHour());
        this.createEqParam(doc, event, "minute", this.getStrMinute());
        this.createEqParam(doc, event, "second", this.getStrSecond());
        this.createEqParam(doc, event, "latitude", this.getStrLatitude());
        this.createEqParam(doc, event, "longitude", this.getStrLongitude());
        this.createEqParam(doc, event, "depth", this.getStrDepth());
        this.createEqParam(doc, event, "magnitude", this.getStrMagnitude());
        if (this.isNumStations) {
            this.createEqParam(doc, event, "num-stations", this.getStrNumStations());
        }
        if (this.isNumPhases) {
            this.createEqParam(doc, event, "num-phases", this.getStrNumPhases());
        }
        if (this.isDistFirstStation) {
            this.createEqParam(doc, event, "dist-first-station", this.getStrDistFirstStation());
        }
        if (this.isRmsError) {
            this.createEqParam(doc, event, "rms-error", this.getStrRmsError());
        }
        if (this.isHorizontalError) {
            this.createEqParam(doc, event, "hor-error", this.getStrHorizontalError());
        }
        if (this.isVerticalError) {
            this.createEqParam(doc, event, "ver-error", this.getStrVerticalError());
        }
        if (this.isAzimuthalGap) {
            this.createEqParam(doc, event, "azimuthal-gap", this.getStrAzimuthalGap());
        }
        if (this.isMagnitudeType) {
            this.createEqParam(doc, event, "magnitude-type", this.getStrMagnitudeType());
            this.createEqParam(doc, event, "magnitude-type-ext", this.getStrMagnitudeTypeExt());
        }
        if (this.isNumStationsForMagnitude) {
            this.createEqParam(doc, event, "num-stations-mag", this.getStrNumStationsForMagnitude());
        }
        if (this.isStandardErrorMagnitude) {
            this.createEqParam(doc, event, "stand-mag-error", this.getStrStandardErrorMagnitude());
        }
        if (this.isLocationMethod) {
            this.createEqParam(doc, event, "location-method", this.getStrLocationMethod());
            this.createEqParam(doc, event, "location-method-ext", this.getStrLocationMethodExt());
        }
    }

    public String getEventIDKey() {
        return this.getNetIDi() + this.getEventID();
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public Point getPoint() {
        if (this.point == null) {
            this.point = EQEventsUtils.createPoint(this);
        }
        return this.point;
    }

    public Date getTime() {
        return this.getDateTime().getTime();
    }
}

