/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import qdm.Config;
import qdm.EQ;
import qdm.EventHistory;
import qdm.HistSort;
import qdm.History;
import qdm.TimeSort;

public class HistCat {
    public History hist;
    public TreeSet cat;
    public TreeSet deletecat;
    String netid;

    public HistCat(String netid, String hist_ext, Comparator comp) {
        this.netid = new String(netid);
        this.hist = new History(netid, hist_ext, comp);
        this.createCat();
    }

    public void createCat() {
        HashMap<String, EventHistory> events = new HashMap<String, EventHistory>();
        this.cat = new TreeSet(new TimeSort());
        this.deletecat = new TreeSet(new TimeSort());
        Iterator<Object> i = this.hist.iterator();
        while (i.hasNext()) {
            EQ eq = (EQ)i.next();
            String id = eq.getEventID();
            EventHistory history = (EventHistory)events.get(id);
            if (history == null) {
                history = new EventHistory();
                events.put(id, history);
            }
            history.update(eq);
        }
        i = events.values().iterator();
        while (i.hasNext()) {
            EventHistory event = (EventHistory)i.next();
            if (event.isDelete()) {
                if (event.getEQ() == null) continue;
                this.deletecat.add(event.getEQ());
                continue;
            }
            if (event.getEQ() == null) continue;
            this.cat.add(event.getEQ());
        }
    }

    public void writeCat() {
        String catfn = Config.catalog + this.netid + ".cat";
        if (this.cat.size() == 0) {
            File file = new File(catfn);
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        try {
            FileWriter fw = new FileWriter(catfn);
            Iterator it = this.cat.iterator();
            while (it.hasNext()) {
                EQ eq = (EQ)it.next();
                fw.write(eq.getTimeStamp() + eq.getData() + Config.eol);
            }
            fw.close();
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, "IOException " + e + " writing " + catfn);
        }
        this.writeDeleteCat();
    }

    public void writeDeleteCat() {
        String catfn = Config.catalog + this.netid + ".delete";
        if (this.deletecat.size() == 0) {
            File file = new File(catfn);
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        try {
            FileWriter fw = new FileWriter(catfn);
            Iterator it = this.deletecat.iterator();
            while (it.hasNext()) {
                EQ eq = (EQ)it.next();
                fw.write(eq.getTimeStamp() + eq.getData() + Config.eol);
            }
            fw.close();
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, "IOException " + e + " writing " + catfn);
        }
    }

    public void trim(int daysago, String initdate) {
        if (this.hist.size() == 0) {
            return;
        }
        this.hist = new History(this.hist, daysago, initdate, new HistSort());
        this.hist.hasChanged();
        this.hist.writeHist();
        this.createCat();
        this.writeCat();
    }
}

