/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;
import qdm.Config;
import qdm.EQ;
import qdm.EQx;
import qdm.HistCat;
import qdm.HistSort;
import qdm.History;
import qdm.TimeSort;
import qdmutil.EQEventsUtils;
import qdmutil.LogIt;
import qdmutil.Region;
import qdmutil.Regions;
import qdmutil.Util;

public class Histories
extends TreeMap {
    Regions regions;
    LogIt logIt = Config.getLogIt();
    static ArrayList toosoon;
    LinkedList near;

    public Histories() {
        String netid;
        this.regions = Config.getRegions();
        Iterator it = this.regions.iterator();
        toosoon = new ArrayList();
        while (it.hasNext()) {
            Region region = (Region)it.next();
            netid = region.netid;
            super.put(netid, new HistCat(netid, ".hist", new HistSort()));
        }
        netid = "us";
        super.put(netid, new HistCat(netid, ".hist", new HistSort()));
    }

    public String getHiVer(String eventid, String netid) {
        HistCat histcat = (HistCat)super.get(netid);
        History hist = null;
        if (histcat != null) {
            hist = histcat.hist;
        }
        if (hist != null) {
            String ver = hist.getHiVer(eventid);
            return ver;
        }
        return "0";
    }

    public boolean getTrump(String eventid, String netid) {
        HistCat histcat = (HistCat)super.get(netid);
        History hist = null;
        boolean trump = false;
        if (histcat != null) {
            hist = histcat.hist;
        }
        if (hist != null) {
            trump = hist.getTrump(eventid);
        }
        return trump;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int update(String Filename) {
        String netfile = "";
        boolean first = true;
        LogIt logIt = Config.getLogIt();
        int ret = 0;
        try {
            String linein;
            FileReader fr = new FileReader(Filename);
            BufferedReader br = new BufferedReader(fr);
            while (null != (linein = br.readLine()) && linein.length() >= 5) {
                String code;
                EQ eq;
                block14: {
                    block15: {
                        eq = new EQ(linein);
                        code = eq.getCode();
                        if (!first) break block15;
                        netfile = eq.getNetID();
                        if (this.regions.isValidnetID(netfile)) {
                            this.touchAlive(netfile);
                            first = false;
                            break block14;
                        } else {
                            String linenew = linein.substring(1);
                            eq = new EQ(linenew);
                            code = eq.getCode();
                            netfile = eq.getNetID();
                            if (this.regions.isValidnetID(netfile)) {
                                this.touchAlive(netfile);
                                first = false;
                                break block14;
                            } else {
                                eq = new EQ(linein);
                                netfile = eq.getNetID();
                                logIt.write(1, true, "Invalid network id (" + netfile + ") in " + eq);
                                continue;
                            }
                        }
                    }
                    if (!netfile.equals(eq.getNetID())) {
                        logIt.write(1, true, "Invalid netID: " + eq);
                        logIt.write(1, true, "Skip this line");
                        continue;
                    }
                }
                if (code.equals("E ") || code.equals("DE") || code.equals("TR")) {
                    History hist;
                    HistCat hc;
                    if (!eq.eventinfo() || (hc = (HistCat)super.get(netfile)) == null || (hist = hc.hist) == null) continue;
                    if (code.equals("E ") && eq.tooOld()) {
                        logIt.write(2, false, "Event too old");
                        continue;
                    }
                    hist.add(eq);
                    ++ret;
                    continue;
                }
                if (code.equals("TX")) {
                    linein = eq.toString() + Config.eol;
                    while (br.ready()) {
                        linein = linein + br.readLine() + Config.eol;
                    }
                    this.message(linein, netfile);
                    continue;
                }
                if (code.equals("LI")) {
                    this.addon(eq.toString(), netfile);
                    continue;
                }
                if (code.equals("A ")) {
                    this.alive(eq.toString(), netfile);
                    continue;
                }
                this.dunno(eq.toString());
            }
            br.close();
            return ret;
        }
        catch (Exception e) {
            Config.getLogIt().write(1, true, "Histories Exception " + e + " reading " + Filename);
        }
        return ret;
    }

    private void message(String linein, String netfile) {
        String filename = Config.eqcomments + netfile + linein.substring(2, 10) + "." + linein.substring(12, 14) + ".msg";
        filename = Util.unblank(filename);
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write("event message version " + linein.substring(12, 14) + " issued at " + Util.timeStamp() + ":" + Config.eol + Config.eol);
            fw.write(linein.substring(14));
            fw.close();
        }
        catch (Exception e) {
            Config.getLogIt().write(1, true, "Exception " + e + " opening " + filename);
        }
        Iterator it = Config.outputdirs.iterator();
        while (it.hasNext()) {
            String destination = (String)it.next() + filename.substring(Config.eqcomments.length());
            try {
                Util.copyFile(filename, destination);
            }
            catch (IOException e) {
                Config.getLogIt().write(1, true, "Problem copying from " + filename + " to " + destination);
            }
        }
    }

    private void addon(String linein, String netfile) {
        String filename = Config.eqaddons + netfile + linein.substring(2, 10) + "." + linein.substring(12, 14);
        filename = Util.unblank(filename);
        StringTokenizer tok = new StringTokenizer(linein.substring(14));
        String addtype = tok.nextToken();
        String addurl = tok.nextToken();
        int z = linein.indexOf(addurl);
        z += addurl.length();
        try {
            while (linein.charAt(z) == ' ') {
                ++z;
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        String addtext = linein.substring(z);
        addtext = Util.deblank(addtext);
        filename = filename + "." + addtype;
        filename = addtext.compareTo("delete") == 0 ? filename + ".del" : filename + ".add";
        File file = new File(filename);
        if (file.exists()) {
            Config.getLogIt().write(2, true, "Found existing file " + filename + ". Will overwrite this old addon.");
        }
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write("Event addon type " + addtype + " version " + linein.substring(12, 14) + " issued at: " + Util.timeStamp() + Config.eol);
            fw.write("\"" + addurl + "\"\"" + addtext + Config.eol);
            fw.close();
        }
        catch (Exception e) {
            Config.getLogIt().write(1, true, "Exception " + e + " opening " + filename);
        }
        Iterator it = Config.outputdirs.iterator();
        while (it.hasNext()) {
            String destination = (String)it.next() + filename.substring(Config.eqaddons.length());
            try {
                Util.copyFile(filename, destination);
            }
            catch (IOException e) {
                Config.getLogIt().write(1, true, "Problem copying from " + filename + " to " + destination);
            }
        }
    }

    private void dunno(String linein) {
        Config.getLogIt().write(1, true, "Confused by and skipping " + linein);
    }

    private void alive(String linein, String netfile) {
        String filename = "catalog/" + netfile + ".alive";
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write(Util.timeStamp() + Config.eol);
            fw.write(linein + Config.eol);
            fw.close();
            Config.getLogIt().write(3, true, "Received alive message from network " + netfile);
        }
        catch (Exception e) {
            Config.getLogIt().write(1, true, "Exception " + e + " opening " + filename);
        }
    }

    public boolean writeHist() {
        boolean ret = false;
        Collection col = super.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            HistCat histcat = (HistCat)it.next();
            History hist = histcat.hist;
            boolean check = hist.writeHist();
            if (check) {
                histcat.createCat();
                histcat.writeCat();
            }
            if (ret || !check) continue;
            ret = true;
        }
        return ret;
    }

    void addDups(Element eqElement, ArrayList dups) {
        if (dups.size() == 0) {
            return;
        }
        Iterator dup_it = dups.iterator();
        while (dup_it.hasNext()) {
            eqElement.appendChild((Element)dup_it.next());
        }
        dups.clear();
    }

    public void trim(int daysago, String initdate) {
        Collection col = super.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            HistCat histcat = (HistCat)it.next();
            histcat.trim(daysago, initdate);
        }
    }

    public void merge() {
        History merge = new History((Comparator)new TimeSort());
        Set set = super.keySet();
        Iterator<Object> it = set.iterator();
        while (it.hasNext()) {
            String netid = (String)it.next();
            HistCat hc = (HistCat)super.get(netid);
            hc.trim(Config.retain_events, Config.initial_date);
            TreeSet cat = hc.cat;
            if (cat.size() > 0) {
                merge.addAll(cat);
            }
            cat = null;
            System.gc();
        }
        this.logIt.write(2, true, "Merge network files into merge.sum.");
        this.logIt.write(2, true, "Write merge.nts and merge.xml");
        String mergefntemp = Config.catalog + "merge.sum.temp";
        String ntsfntemp = Config.catalog + "merge.nts.temp";
        String dupfntemp = Config.catalog + "merge.replace.temp";
        DocumentImpl merge_doc = new DocumentImpl();
        Element merge_root = merge_doc.createElement("merge");
        merge_doc.appendChild(merge_root);
        try {
            TreeMap<String, String> duplicates = new TreeMap<String, String>();
            FileWriter fw = new FileWriter(mergefntemp);
            FileWriter ntsfw = new FileWriter(ntsfntemp);
            FileWriter dupfw = new FileWriter(dupfntemp);
            it = merge.iterator();
            boolean first = true;
            this.near = new LinkedList();
            Calendar now = Util.getCurrTime();
            Element dup = null;
            ArrayList<Element> dups = new ArrayList<Element>(3);
            block3: while (it.hasNext()) {
                EQx eq_last;
                EQx eq_first;
                EQ e1 = (EQ)it.next();
                EQx eq = new EQx(e1);
                this.near.add(eq);
                Calendar eqdate = eq.getDateTime();
                eqdate.add(12, 10);
                if (!eq.isAuthor() && eqdate.after(now)) {
                    this.near.removeLast();
                    toosoon.add(eqdate);
                    continue;
                }
                if (this.near.size() <= 1) continue;
                while (this.near.size() > 1 && !EQEventsUtils.tooCloseInTime(eq_first = (EQx)this.near.getFirst(), eq_last = (EQx)this.near.getLast())) {
                    this.out(eq_first, fw, ntsfw);
                    Element eqElement = eq_first.buildElement(merge_doc);
                    this.addDups(eqElement, dups);
                    merge_doc.getDocumentElement().appendChild(eqElement);
                    this.near.removeFirst();
                }
                if (this.near.size() <= 1) continue;
                ListIterator near_it = this.near.listIterator();
                eq_last = (EQx)this.near.getLast();
                while (near_it.nextIndex() < this.near.size() - 1) {
                    EQx eq_first2 = (EQx)near_it.next();
                    if (!EQEventsUtils.duplicate(eq_first2, eq_last)) continue;
                    int j = EQEventsUtils.lowpriority(eq_first2, eq_last);
                    this.logIt.write(2, false, "These are duplicates:");
                    this.logIt.write(2, false, eq_first2.toString());
                    this.logIt.write(2, false, eq_last.toString());
                    dup = merge_doc.createElement("duplicate");
                    if (j == 1) {
                        this.logIt.write(2, false, "Chose first event");
                        duplicates.put(eq_last.getFullEventID(), eq_first2.getFullEventID());
                        eq_last.setParam(dup, merge_doc);
                        dups.add(dup);
                        this.near.removeLast();
                        near_it = this.near.listIterator();
                        continue block3;
                    }
                    this.logIt.write(2, false, "Chose second event");
                    duplicates.put(eq_first2.getFullEventID(), eq_last.getFullEventID());
                    eq_first2.setParam(dup, merge_doc);
                    dups.add(dup);
                    this.near.remove(eq_first2);
                    near_it = this.near.listIterator();
                }
            }
            while (this.near.size() >= 1) {
                EQx eq_first = (EQx)this.near.getFirst();
                this.out(eq_first, fw, ntsfw);
                Element eqElement = eq_first.buildElement(merge_doc);
                this.addDups(eqElement, dups);
                merge_doc.getDocumentElement().appendChild(eqElement);
                this.near.removeFirst();
            }
            fw.close();
            ntsfw.close();
            Iterator d = duplicates.keySet().iterator();
            while (d.hasNext()) {
                String key = (String)d.next();
                String value = (String)duplicates.get(key);
                dupfw.write(key + "\t" + value + "\n");
            }
            dupfw.close();
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, "IOException " + e + " writing " + mergefntemp);
        }
        this.deleteRenameRename("mergeold.sum", "merge.sum", "merge.sum.temp");
        this.deleteRenameRename("mergeold.nts", "merge.nts", "merge.nts.temp");
        this.deleteRenameRename("mergeold.replace", "merge.replace", "merge.replace.temp");
        this.writeDoc(merge_doc, "merge.temp.xml");
        this.deleteRenameRename("mergeold.xml", "merge.xml", "merge.temp.xml");
        this.mergeDelete();
    }

    private void mergeDelete() {
        File[] files = new File(Config.catalog).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".delete");
            }
        });
        try {
            BufferedWriter fwrite = new BufferedWriter(new FileWriter(Config.catalog + "merge.delete"));
            for (int i = 0; i < files.length; ++i) {
                String line;
                BufferedReader fread = new BufferedReader(new FileReader(files[i]));
                while ((line = fread.readLine()) != null) {
                    fwrite.write(line + "\n");
                }
                fread.close();
            }
            fwrite.close();
        }
        catch (IOException e) {
            System.err.println("An error occured while merging delete files " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoc(DocumentImpl doc, String fn) {
        FileOutputStream fos = null;
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            XMLSerializer ser = new XMLSerializer(format);
            fos = new FileOutputStream(Config.catalog + fn);
            ser.setOutputByteStream(fos);
            ser.serialize(doc);
        }
        catch (Exception x) {
            this.logIt.write(1, true, "Problem writing xml file: " + fn);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iox) {}
        }
    }

    private void deleteRenameRename(String fnold, String fn, String fntemp) {
        File filetemp;
        fnold = Config.catalog + fnold;
        File fileold = new File(fnold);
        fileold.delete();
        fn = Config.catalog + fn;
        File file = new File(fn);
        if (!file.renameTo(fileold)) {
            this.logIt.write(1, true, "Problem renaming " + fn + " to " + fnold);
        }
        if (!(filetemp = new File(fntemp = Config.catalog + fntemp)).renameTo(file)) {
            this.logIt.write(1, true, "Problem renaming " + fntemp + " to " + fn);
        }
    }

    private void out(EQx eq, FileWriter fw, FileWriter ntsfw) {
        String data = eq.getData();
        try {
            fw.write(eq.getTimeStamp() + data + "\r\n");
            ntsfw.write(data + Config.eol);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
    }

    private void touchAlive(String netfile) {
        String filename = "catalog/" + netfile + ".alive";
        File file = new File(filename);
        if (file.exists()) {
            file.setLastModified(new Date().getTime());
        } else {
            try {
                FileWriter fos = new FileWriter(file);
                fos.close();
            }
            catch (IOException e) {
                Config.getLogIt().write(1, true, "IOException " + e + " creating " + filename);
            }
        }
    }
}

