/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import qdm.Config;
import qdm.EQ;
import qdmutil.LogIt;
import qdmutil.Util;

public class History
extends TreeSet {
    boolean changed;
    String netid;
    LogIt logIt;

    public History(Comparator comp) {
        super(comp);
    }

    public History(History oldhist, int daysago, String initdate, Comparator comp) {
        super(comp);
        this.netid = oldhist.getNetID();
        Calendar now = Util.getCurrTime();
        now.add(6, -daysago);
        String initdate_daysago = Util.charCalendar(now);
        if (initdate_daysago.compareTo(initdate) > 0) {
            initdate = initdate_daysago;
        }
        Iterator it = oldhist.iterator();
        LogIt logIt = Config.getLogIt();
        while (it.hasNext()) {
            String ts;
            EQ eq = (EQ)it.next();
            String code = eq.getCode();
            int i = eq.getDate().compareTo(initdate);
            if (i < 0 || (ts = eq.getTimeStamp()).length() < 18 || !code.equals("E ") && !code.equals("DE") && !code.equals("TR")) continue;
            super.add(new EQ(eq));
        }
    }

    public History(String netid, String file_ext, Comparator comp) {
        super(comp);
        BufferedReader br;
        this.netid = new String(netid);
        this.logIt = Config.getLogIt();
        this.changed = false;
        String filename = Config.catalog + netid + file_ext;
        try {
            FileReader fr = new FileReader(filename);
            br = new BufferedReader(fr);
        }
        catch (IOException e) {
            this.logIt.write(2, false, "File not found: " + filename);
            return;
        }
        try {
            String linein;
            while (null != (linein = br.readLine())) {
                EQ eq;
                try {
                    eq = new EQ(linein.substring(20), linein.substring(0, 20));
                }
                catch (IndexOutOfBoundsException e) {
                    this.logIt.write(2, true, "In History.  Line too short: " + linein);
                    continue;
                }
                if (!eq.isValidDate()) continue;
                super.add(eq);
            }
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, e + " reading " + filename);
        }
    }

    public String getNetID() {
        return new String(this.netid);
    }

    public void hasChanged() {
        this.changed = true;
    }

    public boolean add(Object obj) {
        this.changed = true;
        return super.add(obj);
    }

    public String getHiVer(String eventid) {
        String ver = "0";
        Iterator it = super.iterator();
        while (it.hasNext()) {
            String ver2;
            EQ eq = (EQ)it.next();
            if (!eq.getEventID().equals(eventid) || ver.compareTo(ver2 = eq.getVersion()) >= 0) continue;
            ver = ver2;
        }
        return ver;
    }

    public boolean getTrump(String eventid) {
        boolean trump = false;
        Iterator it = super.iterator();
        while (it.hasNext()) {
            EQ eq = (EQ)it.next();
            if (!eq.getEventID().equals(eventid) || !eq.getTrump()) continue;
            trump = true;
            break;
        }
        return trump;
    }

    public boolean writeHist() {
        if (!this.changed) {
            return false;
        }
        boolean first = true;
        String fn = Config.catalog + this.netid + ".hist";
        String fnold = fn + ".sort";
        File file2 = new File(fnold);
        file2.delete();
        File file1 = new File(fn);
        if (file1.exists()) {
            file1.renameTo(file2);
        }
        String oldid = "";
        String newid = "";
        if (super.size() == 0) {
            return false;
        }
        try {
            FileWriter fw = new FileWriter(fn);
            Iterator it = super.iterator();
            while (it.hasNext()) {
                EQ eq = (EQ)it.next();
                fw.write(eq.getTimeStamp() + eq.getData() + Config.eol);
            }
            fw.close();
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, e + " writing " + fn);
        }
        this.changed = false;
        return true;
    }
}

