/*
 * Decompiled with CFR 0.152.
 */
package qdm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.ListIterator;
import org.w3c.dom.Document;
import qdm.Config;
import qdm.Histories;
import qdmutil.LogIt;
import qdmutil.ParseXML;
import qdmutil.Regions;
import qdmutil.Util;

public class Watch
extends Thread {
    private String polldir;
    private File PD;
    private File dataFile;
    private LogIt logIt;
    private static final long PROBLEM_WAIT_TIME = 30000L;

    public Watch() {
        this(Config.pollDirectory());
    }

    public Watch(String poll_directory) {
        this.polldir = new String(poll_directory);
        this.logIt = Config.getLogIt();
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean some = false;
        int day = 0;
        Config.histories = new Histories();
        this.update();
        while (true) {
            Calendar now;
            block26: {
                Iterator it;
                String nowfn;
                String[] files;
                if (Config.exit()) {
                    this.logIt.write(1, true, "***** Watch Loop Died *****");
                    return;
                }
                now = Util.getCurrLocalTime();
                this.PD = new File(this.polldir);
                some = false;
                if (Config.configChanged()) {
                    Config.config.load(false);
                }
                if ((files = this.PD.list()) == null) {
                    Config.mySleep((long)Config.poll_wait_time * 1000L);
                    continue;
                }
                this.logIt.write(5, true, "Number of files: " + files.length);
                int c = 0;
                while (true) {
                    String file;
                    block25: {
                        Iterator it2;
                        String xmlFilename;
                        String filename;
                        block31: {
                            block27: {
                                block28: {
                                    ParseXML xml;
                                    block29: {
                                        block30: {
                                            Regions regions;
                                            boolean isxml;
                                            if (c >= files.length) break block27;
                                            file = files[c];
                                            this.dataFile = new File(this.PD, file);
                                            this.logIt.write(5, false, "Read " + file);
                                            filename = null;
                                            try {
                                                filename = this.dataFile.getCanonicalPath();
                                                isxml = this.isXML(filename);
                                            }
                                            catch (Exception e) {
                                                isxml = false;
                                            }
                                            if (!isxml) break block28;
                                            this.logIt.write(5, true, "Parse XML file: " + file);
                                            xml = new ParseXML(this.dataFile);
                                            xmlFilename = xml.getFilename();
                                            if (null == xmlFilename) break block29;
                                            this.logIt.write(1, true, "Parsed name: " + xmlFilename);
                                            if (!xmlFilename.equals("regions.xml")) break block30;
                                            this.logIt.write(5, true, "Write new regions.xml file");
                                            try {
                                                Util.copyFile(filename, xmlFilename);
                                            }
                                            catch (IOException e) {
                                                Config.getLogIt().write(1, true, "Problem creating: " + xmlFilename);
                                            }
                                            if (!Config.init(this.logIt)) {
                                                System.exit(1);
                                            }
                                            if ((regions = Config.getRegions()).size() == 0) {
                                                Config.getLogIt().write(1, true, "Problem reading regions file.  Exit.");
                                                System.exit(1);
                                            }
                                            Config.getLogIt().write(1, true, "Regions constructed from regions.xml");
                                            break block25;
                                        }
                                        it2 = Config.outputdirs.iterator();
                                        break block31;
                                    }
                                    Document event_doc = xml.getDocument();
                                    if (null != event_doc) break block25;
                                    this.logIt.write(1, true, "Problem parsing " + file);
                                    break block25;
                                }
                                try {
                                    if (0 < Config.histories.update(filename)) {
                                        some = true;
                                    }
                                    break block25;
                                }
                                catch (Exception e) {
                                    this.logIt.write(2, true, "Exception: " + e);
                                }
                                break block25;
                            }
                            ListIterator lit = Histories.toosoon.listIterator();
                            while (lit.hasNext()) {
                                Calendar cal = (Calendar)lit.next();
                                if (!now.after(cal)) continue;
                                this.logIt.write(2, true, "Found queued wait file now old enough to merge");
                                some = true;
                                lit.remove();
                            }
                            if (some) {
                                Config.histories.merge();
                                nowfn = Util.charCalendar(now);
                                nowfn = nowfn.substring(6, 14);
                                it = Config.outputdirs.iterator();
                                break;
                            }
                            break block26;
                        }
                        while (it2.hasNext()) {
                            String destination = (String)it2.next() + xmlFilename;
                            try {
                                Util.copyFile(filename, destination);
                            }
                            catch (IOException e) {
                                Config.getLogIt().write(1, true, "Problem copying from " + filename + " to " + destination);
                            }
                        }
                    }
                    File oldfile = new File(Config.oldinput + file);
                    if (oldfile.exists()) {
                        oldfile.delete();
                    }
                    this.dataFile.renameTo(oldfile);
                    ++c;
                }
                while (it.hasNext()) {
                    String next_nowfn = (String)it.next() + "data" + nowfn + ".cat";
                    this.logIt.write(2, false, "Writing to " + next_nowfn);
                    try {
                        FileWriter fw = new FileWriter(next_nowfn);
                        fw.close();
                    }
                    catch (IOException e) {
                        this.logIt.write(1, true, "Problem writing to " + next_nowfn);
                    }
                }
            }
            if (now.get(5) != day && now.get(11) == (int)Config.maintenance_hour) {
                int mm = (int)(0.5 + (double)(60.0f * (Config.maintenance_hour - (float)((int)Config.maintenance_hour))));
                if (now.get(12) >= mm) {
                    this.logIt.write(1, true, "Daily update");
                    this.update();
                    day = now.get(5);
                }
            }
            Config.mySleep((long)Config.poll_wait_time * 1000L);
        }
    }

    void update() {
        this.logIt.write(4, true, "Check to see if old files should be deleted.");
        Iterator it = Config.outputdirs.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            Util.deleteFiles(dir, Config.retain_outputspool);
        }
        Util.deleteFiles(Config.eqcomments, Config.retain_outputspool);
        Util.deleteFiles(Config.eqaddons, Config.retain_outputspool);
        Util.deleteFiles(Config.oldInputDirectory(), Config.retain_oldinput);
        Util.deleteFiles(Config.logDirectory(), Config.retain_logdir);
        Config.histories.trim(Config.retain_events, Config.initial_date);
        Config.histories.merge();
    }

    boolean isXML(String filename) {
        boolean ret = false;
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            String linein = br.readLine();
            if (linein == null) {
                ret = false;
            } else if (linein.length() < 5) {
                ret = false;
            } else if (linein.substring(0, 5).equals("<?xml")) {
                ret = true;
            }
            br.close();
        }
        catch (IOException e) {
            ret = false;
        }
        return ret;
    }
}

