/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import qdmutil.LogIt;
import qdmutil.Regions;

public abstract class Config {
    public static final String VERSION = "1.2.0 Level 2007/08/06";
    public static final long ONE_SEC_WAIT = 1000L;
    public static final long HALF_SEC_WAIT = 500L;
    public static final long TENTH_SEC_WAIT = 100L;
    public static final long FIVE_SEC_WAIT = 5000L;
    public static final long ONE_MIN_WAIT = 60000L;
    public static final long ONE_HOUR_WAIT = 3600000L;
    public static final long ONE_DAY_WAIT = 86400000L;
    public static final long ONE_WEEK_WAIT = 604800000L;
    public static String regionsFileName = "regions.xml";
    private static LogIt log_it = null;
    private static Regions regions = null;

    public static LogIt getLogIt() {
        return log_it;
    }

    public static void setLogIt(LogIt log) {
        log_it = log;
    }

    public static Regions getRegions() {
        return regions;
    }

    public static void kill() {
        System.exit(0);
    }

    public static void error(String err) {
        if (log_it == null) {
            System.out.println(err);
        } else {
            log_it.write(1, true, err);
        }
    }

    public static boolean init(LogIt log_it) {
        log_it.write(1, true, "Fetch regions");
        File file = new File(regionsFileName);
        FileInputStream inputStream = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                log_it.write(1, true, "" + ex);
            }
        }
        return Config.init(log_it, inputStream);
    }

    public static boolean init(LogIt log_it, InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        log_it.write(1, true, "init(log_it,inputStream)");
        return Config.init(log_it, new InputSource(inputStream));
    }

    public static boolean init(LogIt log_it, InputSource regionsSource) {
        if (regionsSource == null) {
            return false;
        }
        Config.log_it = log_it;
        try {
            regions = new Regions(regionsSource);
        }
        catch (Exception e) {
            log_it.write(1, true, e + " regions.xml file found but there was a problem parsing it.");
        }
        if (regions == null) {
            log_it.write(1, true, "No regions.xml file.  Exit");
            return false;
        }
        log_it.write(1, true, "Regions successfully read from regions.xml.");
        return true;
    }
}

