/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import qdmutil.Config;
import qdmutil.EQEvent;
import qdmutil.LogIt;
import qdmutil.ParseXML;
import qdmutil.Point;
import qdmutil.Region;

public class Regions
extends ArrayList {
    private ArrayList netids;
    Document doc;
    public String defaultNetid;

    public Regions(String RegDir) {
        this.netids = new ArrayList();
        this.defaultNetid = null;
        try {
            String line;
            String file = RegDir + "regions.cnss";
            FileReader fr = null;
            try {
                fr = new FileReader(file);
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + file + " not found.");
                return;
            }
            BufferedReader br = new BufferedReader(fr);
            while (null != (line = br.readLine())) {
                if (line.length() < 5 || line.charAt(0) == '#') continue;
                StringTokenizer tok = new StringTokenizer(line);
                String netid = tok.nextToken();
                String regid = tok.nextToken();
                String fn = tok.nextToken();
                netid = netid.toLowerCase();
                Region region = null;
                if (fn.length() == 0) continue;
                try {
                    region = new Region(netid, regid, RegDir, fn);
                }
                catch (IOException e) {
                    Config.getLogIt().write(1, true, "Exception" + e + "trying to get new region: " + netid + " " + regid + " filename:" + fn);
                    continue;
                }
                if (region.size() == 0) {
                    this.defaultNetid = netid;
                }
                super.add(region);
                this.netids.add(netid);
            }
        }
        catch (IOException e) {
            Config.getLogIt().write(1, true, "IOException " + e + " reading regions.cnssm");
            Config.kill();
        }
    }

    public Regions(Document doc) {
        this.doc = doc;
        this.buildRegions();
    }

    private void buildRegions() {
        LogIt logIt = Config.getLogIt();
        this.netids = new ArrayList();
        NodeList children = this.doc.getElementsByTagName("net");
        int nNodes = children.getLength();
        if (nNodes == 0) {
            logIt.write(1, true, "Error. No \"net\" element found in file");
            return;
        }
        for (int i = 0; i < nNodes; ++i) {
            Element net = (Element)children.item(i);
            String netid = net.getAttribute("code");
            netid = netid.toLowerCase();
            logIt.write(1, false, "netid: " + netid);
            NodeList regions = net.getElementsByTagName("region");
            int nReg = regions.getLength();
            for (int j = 0; j < nReg; ++j) {
                Element reg = (Element)regions.item(j);
                String regid = reg.getAttribute("code");
                logIt.write(1, false, "  regid: " + regid);
                Region region = new Region(netid, regid, reg);
                if (region.size() == 0) {
                    this.defaultNetid = netid;
                }
                super.add(region);
                this.netids.add(netid);
            }
        }
    }

    public Regions() {
        File file = new File("regions.xml");
        if (!file.exists()) {
            this.netids = null;
            return;
        }
        try {
            this.doc = ParseXML.parse(file);
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
        this.buildRegions();
    }

    public boolean isValidnetID(String netid) {
        return this.netids.contains(netid);
    }

    public Regions(InputSource is) {
        try {
            this.doc = ParseXML.parse(is);
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
        this.buildRegions();
    }

    public boolean isDefaultNetID(String netid) {
        return this.defaultNetid.equals(netid);
    }

    public boolean isDefaultNetID(EQEvent eq) {
        return this.isDefaultNetID(eq.getNetID());
    }

    public boolean isAuthor(String netid, Point p) {
        boolean author;
        Iterator it = this.iterator();
        if (this.isDefaultNetID(netid)) {
            author = true;
            while (it.hasNext()) {
                Region region = (Region)it.next();
                if (region.netid.equals(netid) || !region.inpoly(p)) continue;
                author = false;
                break;
            }
        } else {
            author = false;
            while (it.hasNext()) {
                Region region = (Region)it.next();
                if (!netid.equals(region.netid) || !region.inpoly(p)) continue;
                author = true;
                break;
            }
        }
        return author;
    }

    public boolean isAuthor(EQEvent eq) {
        return this.isAuthor(eq.getNetID(), eq.getPoint());
    }
}

