/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import qdmutil.Config;

public class Util {
    private static TimeZone tz = null;

    public static String unblank(String s) {
        int blank;
        while (0 <= (blank = s.indexOf(32))) {
            s = new String(new StringBuffer(s).deleteCharAt(blank));
        }
        return s;
    }

    public static String deblank(String s) {
        int i;
        int n = s.length();
        for (i = n - 1; i >= 0 && s.charAt(i) == ' '; --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String timeStamp() {
        if (tz == null) {
            tz = TimeZone.getTimeZone("GMT");
        }
        GregorianCalendar cal = new GregorianCalendar(tz);
        String sret = "" + cal.get(1) + (101 + cal.get(2));
        sret = sret + (100 + cal.get(5)) + (100 + cal.get(11));
        sret = sret + (100 + cal.get(12)) + (100 + cal.get(13)) + " ";
        StringBuffer ret = new StringBuffer(sret);
        ret.setCharAt(4, '/');
        ret.setCharAt(7, '/');
        ret.setCharAt(10, '_');
        ret.setCharAt(13, ':');
        ret.setCharAt(16, ':');
        return new String(ret);
    }

    public static Calendar getCurrTime() {
        if (tz == null) {
            tz = TimeZone.getTimeZone("GMT");
        }
        return new GregorianCalendar(tz);
    }

    public static Calendar getCurrLocalTime() {
        return new GregorianCalendar();
    }

    public static int atoi(String s) {
        int i = 0;
        s = s.replace(' ', '0');
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    public static void deleteFiles(String dir, int days) {
        if (days == 0) {
            return;
        }
        Date now = new Date();
        long time_now = now.getTime();
        File direct = new File(dir);
        if (!direct.exists() || !direct.canRead()) {
            Config.error("Cannot access directory: " + dir);
            return;
        }
        if (!direct.isDirectory()) {
            Config.error("Directory [" + dir + "] is not actually a directory!!!");
            return;
        }
        String[] files = direct.list();
        for (int c = 0; c < files.length; ++c) {
            long dd;
            File dataFile = new File(direct, files[c]);
            long this_file_time = dataFile.lastModified();
            if (this_file_time >= time_now - (dd = (long)days * 86400000L)) continue;
            Config.getLogIt().write(5, true, "Delete " + files[c]);
            dataFile.delete();
        }
    }

    public static String charCalendar(Calendar cal) {
        long d = 1 + cal.get(2) + 100 * cal.get(1);
        d = (long)cal.get(5) + 100L * d;
        d = (long)cal.get(11) + 100L * d;
        d = (long)cal.get(12) + 100L * d;
        d = (long)cal.get(13) + 100L * d;
        d = 10L * d;
        return "" + d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source_name, String dest_name) throws IOException {
        File source_file = new File(source_name);
        File dest_file = new File(dest_name);
        FileInputStream source = null;
        FileOutputStream destination = null;
        try {
            int bytes_read;
            source = new FileInputStream(source_file);
            destination = new FileOutputStream(dest_file);
            byte[] buffer = new byte[1024];
            while ((bytes_read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytes_read);
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

