/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.xml.sax.InputSource;
import qdmutil.LogIt;
import qdmutil.Regions;

public abstract class Config {
    public static final String VERSION = "1.1.6 Level 2005/02/07";
    public static final long ONE_SEC_WAIT = 1000L;
    public static final long HALF_SEC_WAIT = 500L;
    public static final long TENTH_SEC_WAIT = 100L;
    public static final long FIVE_SEC_WAIT = 5000L;
    public static final long ONE_MIN_WAIT = 60000L;
    public static final long ONE_HOUR_WAIT = 3600000L;
    public static final long ONE_DAY_WAIT = 86400000L;
    public static final long ONE_WEEK_WAIT = 604800000L;
    public static String regionsFileName = "regions.xml";
    private static LogIt log_it = null;
    private static Regions regions = null;

    public static LogIt getLogIt() {
        return log_it;
    }

    public static void setLogIt(LogIt logIt) {
        log_it = logIt;
    }

    public static Regions getRegions() {
        return regions;
    }

    public static void kill() {
        System.exit(0);
    }

    public static void error(String string) {
        if (log_it == null) {
            System.out.println(string);
        } else {
            log_it.write(1, true, string);
        }
    }

    public static boolean init(LogIt logIt) {
        logIt.write(1, true, "Fetch regions");
        File file = new File(regionsFileName);
        FileInputStream fileInputStream = null;
        if (file.exists()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logIt.write(1, true, "" + fileNotFoundException);
            }
        }
        return Config.init(logIt, fileInputStream);
    }

    public static boolean init(LogIt logIt, InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        logIt.write(1, true, "init(log_it,inputStream)");
        return Config.init(logIt, new InputSource(inputStream));
    }

    public static boolean init(LogIt logIt, InputSource inputSource) {
        if (inputSource == null) {
            return false;
        }
        log_it = logIt;
        try {
            regions = new Regions(inputSource);
        }
        catch (Exception exception) {
            logIt.write(1, true, exception + " regions.xml file found but there was a problem parsing it.");
        }
        if (regions == null) {
            logIt.write(1, true, "No regions.xml file.  Exit");
            return false;
        }
        logIt.write(1, true, "Regions successfully read from regions.xml.");
        return true;
    }
}

