/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.util.Iterator;
import qdmutil.Config;
import qdmutil.EQEvent;
import qdmutil.Point;

public class EQEventsUtils {
    public static final int TDIFF = 16000;
    public static final float DDIFF = 100.0f;
    public static final int RTDIFF = 10;
    public static final double KMDEG = 111.2;
    public static final double maxlatdiff = 0.8992805755395683;
    protected static final double mincos = Math.cos(Math.toRadians(0.8992805755395683));
    protected static final int DUPLICATE_TRUE = 0;
    protected static final int DUPLICATE_FALSE_SAME_SOURCE = 1;
    protected static final int DUPLICATE_FALSE_TIME_DIFF_LOW = 2;
    protected static final int DUPLICATE_FALSE_TIME_DIFF_HIGH = 3;
    protected static final int DUPLICATE_FALSE_LAT_DIFF = 4;
    protected static final int DUPLICATE_FALSE_DIST_DIFF = 5;

    protected EQEventsUtils() {
    }

    public static boolean determineAuthor(EQEvent eQEvent) {
        return Config.getRegions() != null && Config.getRegions().isAuthor(eQEvent);
    }

    public static double[] calculateDirCos(EQEvent eQEvent) {
        double[] dArray = new double[3];
        double d = eQEvent.getLatitude();
        double d2 = eQEvent.getLongitude();
        double d3 = 0.01745329 * d;
        double d4 = 0.01745329 * d2;
        double d5 = 0.996647 * Math.tan(d3);
        d3 = Math.atan(d5);
        double d6 = 1.570796327 - d3;
        if (d4 < 0.0) {
            d4 += 6.283185307;
        }
        double d7 = Math.sin(d6);
        double d8 = Math.cos(d6);
        double d9 = Math.sin(d4);
        double d10 = Math.cos(d4);
        dArray[0] = d7 * d10;
        dArray[1] = d7 * d9;
        dArray[2] = d8;
        return dArray;
    }

    public static Point createPoint(EQEvent eQEvent) {
        return EQEventsUtils.createPoint(eQEvent.getLongitude(), eQEvent.getLatitude());
    }

    public static Point createPoint(double d, double d2) {
        return new Point(d, d2);
    }

    public static boolean tooCloseInTime(EQEvent eQEvent, EQEvent eQEvent2) {
        return EQEventsUtils.checkTimeDiff(eQEvent, eQEvent2) < 0;
    }

    private static int checkTimeDiff(EQEvent eQEvent, EQEvent eQEvent2) {
        long l;
        long l2 = eQEvent.getTime().getTime();
        long l3 = l2 - (l = eQEvent2.getTime().getTime());
        if (l3 > 16000L) {
            return 3;
        }
        if (l3 < -16000L) {
            return 2;
        }
        return -1;
    }

    protected static int checkDuplicate(EQEvent eQEvent, EQEvent eQEvent2) {
        double[] dArray;
        if (eQEvent.getNetID().equals(eQEvent2.getNetID())) {
            return 1;
        }
        int n = EQEventsUtils.checkTimeDiff(eQEvent, eQEvent2);
        if (n >= 0) {
            return n;
        }
        if (Math.abs(eQEvent.getLatitude() - eQEvent2.getLatitude()) > 0.8992805755395683) {
            return 4;
        }
        double[] dArray2 = eQEvent.getDirCos();
        double d = dArray2[0] * (dArray = eQEvent2.getDirCos())[0] + dArray2[1] * dArray[1] + dArray2[2] * dArray[2];
        if (d < mincos) {
            return 5;
        }
        return 0;
    }

    public static boolean duplicate(EQEvent eQEvent, EQEvent eQEvent2) {
        return EQEventsUtils.checkDuplicate(eQEvent, eQEvent2) == 0;
    }

    protected static String toString(boolean bl) {
        return bl ? "Y" : "N";
    }

    public static String toString(EQEvent eQEvent) {
        return "author=" + EQEventsUtils.toString(eQEvent.isAuthor()) + ", source=" + eQEvent.getNetID() + ", lat=" + eQEvent.getLatitude() + ", long=" + eQEvent.getLongitude() + ", mag=" + eQEvent.getMagnitude() + ", time=" + eQEvent.getTime() + ", trump=" + EQEventsUtils.toString(eQEvent.getTrump());
    }

    public static EQEvent getDuplicate(Iterator iterator, EQEvent eQEvent, boolean bl) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EQEvent)) continue;
            EQEvent eQEvent2 = (EQEvent)e;
            int n = EQEventsUtils.checkDuplicate(eQEvent2, eQEvent);
            switch (n) {
                case 0: {
                    return eQEvent2;
                }
                case 3: {
                    if (!bl) break;
                    return null;
                }
            }
        }
        return null;
    }

    public static int lowpriority(EQEvent eQEvent, EQEvent eQEvent2) {
        if (eQEvent.getTrump()) {
            return 1;
        }
        if (eQEvent2.getTrump()) {
            return 0;
        }
        if (eQEvent.isAuthor() && !eQEvent2.isAuthor()) {
            return 1;
        }
        if (!eQEvent.isAuthor() && eQEvent2.isAuthor()) {
            return 0;
        }
        if (!eQEvent.isAuthor() && !eQEvent2.isAuthor()) {
            String string = eQEvent.getNetID();
            String string2 = eQEvent2.getNetID();
            if (string.equals("us") && !string2.equals("us")) {
                return 1;
            }
            if (!string.equals("us") && string2.equals("us")) {
                return 0;
            }
        }
        if (eQEvent.getMagnitude() >= eQEvent2.getMagnitude()) {
            return 1;
        }
        return 0;
    }
}

