/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import qdmutil.Config;
import qdmutil.LogIt;

public class ParseXML {
    private File file;
    private Document doc;

    public ParseXML(File file) {
        this.file = file;
    }

    public Document getDocument() {
        return this.doc;
    }

    public String getFilename() {
        Element element;
        String string = null;
        LogIt logIt = Config.getLogIt();
        try {
            this.doc = ParseXML.parse(this.file);
        }
        catch (SAXParseException sAXParseException) {
            String string2 = sAXParseException.toString();
            if (string2.length() > 50) {
                logIt.write(1, true, "Parse error: " + string2.substring(0, 50));
                logIt.write(1, true, string2.substring(50));
            } else {
                logIt.write(1, true, "Parse error: " + string2);
            }
            return "";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        NodeList nodeList = this.doc.getElementsByTagName("file");
        if (nodeList.getLength() == 0) {
            logIt.write(1, true, "Error. No file element found in file.");
            return null;
        }
        if (nodeList.getLength() > 1) {
            logIt.write(3, true, "Warning. More than one file element");
        }
        if (nodeList.item(0) instanceof Element && (string = (element = (Element)nodeList.item(0)).getAttribute("name")) != null && string.length() == 0) {
            logIt.write(1, true, "Error. No file \"name\" element found");
            string = null;
        }
        return string;
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        Document document = dOMParser.getDocument();
        return document;
    }

    public static Document parse(File file) throws SAXException, IOException {
        return ParseXML.parse(new InputSource(new FileInputStream(file)));
    }

    public static Document parse(URL uRL) throws SAXException, IOException {
        return ParseXML.parse(new InputSource(uRL.openStream()));
    }
}

