/*
 * Decompiled with CFR 0.152.
 */
package qdmutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import qdmutil.Config;
import qdmutil.EQEvent;
import qdmutil.LogIt;
import qdmutil.ParseXML;
import qdmutil.Point;
import qdmutil.Region;

public class Regions
extends ArrayList {
    private ArrayList netids;
    Document doc;
    public String defaultNetid;

    public Regions(String string) {
        this.netids = new ArrayList();
        this.defaultNetid = null;
        try {
            String string2;
            String string3 = string + "regions.cnss";
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File " + string3 + " not found.");
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while (null != (string2 = bufferedReader.readLine())) {
                if (string2.length() < 5 || string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                string4 = string4.toLowerCase();
                Region region = null;
                if (string6.length() == 0) continue;
                try {
                    region = new Region(string4, string5, string, string6);
                }
                catch (IOException iOException) {
                    Config.getLogIt().write(1, true, "Exception" + iOException + "trying to get new region: " + string4 + " " + string5 + " filename:" + string6);
                    continue;
                }
                if (region.size() == 0) {
                    this.defaultNetid = string4;
                }
                super.add(region);
                this.netids.add(string4);
            }
        }
        catch (IOException iOException) {
            Config.getLogIt().write(1, true, "IOException " + iOException + " reading regions.cnssm");
            Config.kill();
        }
    }

    public Regions(Document document) {
        this.doc = document;
        this.buildRegions();
    }

    private void buildRegions() {
        LogIt logIt = Config.getLogIt();
        this.netids = new ArrayList();
        NodeList nodeList = this.doc.getElementsByTagName("net");
        int n = nodeList.getLength();
        if (n == 0) {
            logIt.write(1, true, "Error. No \"net\" element found in file");
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("code");
            string = string.toLowerCase();
            logIt.write(1, false, "netid: " + string);
            NodeList nodeList2 = element.getElementsByTagName("region");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element2 = (Element)nodeList2.item(j);
                String string2 = element2.getAttribute("code");
                logIt.write(1, false, "  regid: " + string2);
                Region region = new Region(string, string2, element2);
                if (region.size() == 0) {
                    this.defaultNetid = string;
                }
                super.add(region);
                this.netids.add(string);
            }
        }
    }

    public Regions() {
        File file = new File("regions.xml");
        if (!file.exists()) {
            this.netids = null;
            return;
        }
        try {
            this.doc = ParseXML.parse(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.buildRegions();
    }

    public boolean isValidnetID(String string) {
        return this.netids.contains(string);
    }

    public Regions(InputSource inputSource) {
        try {
            this.doc = ParseXML.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.buildRegions();
    }

    public boolean isDefaultNetID(String string) {
        return this.defaultNetid.equals(string);
    }

    public boolean isDefaultNetID(EQEvent eQEvent) {
        return this.isDefaultNetID(eQEvent.getNetID());
    }

    public boolean isAuthor(String string, Point point) {
        boolean bl;
        Iterator iterator = this.iterator();
        if (this.isDefaultNetID(string)) {
            bl = true;
            while (iterator.hasNext()) {
                Region region = (Region)iterator.next();
                if (region.netid.equals(string) || !region.inpoly(point)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
            while (iterator.hasNext()) {
                Region region = (Region)iterator.next();
                if (!string.equals(region.netid) || !region.inpoly(point)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isAuthor(EQEvent eQEvent) {
        return this.isAuthor(eQEvent.getNetID(), eQEvent.getPoint());
    }
}

